<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelRatePlanContract StructType
 * @subpackage Structs
 */
class JPSOAP_HotelRatePlanContract extends JPSOAP_Contract
{
    /**
     * The ContractType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ContractType;
    /**
     * The Comissionable
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Comissionable;
    /**
     * The RecommendedPrices
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $RecommendedPrices;
    /**
     * The BookingFrom
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $BookingFrom;
    /**
     * The BookingTo
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $BookingTo;
    /**
     * The DirectPayment
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $DirectPayment;
    /**
     * The ApplicationTypeOffer
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ApplicationTypeOffer;
    /**
     * The Ages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_Ages
     */
    public $Ages;
    /**
     * The ContractRestrictions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_ContractRestrictions
     */
    public $ContractRestrictions;
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_hotelRatePlanRate
     */
    public $Rates;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_hotelRatePlanTax
     */
    public $Taxes;
    /**
     * The CancellationPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_hotelRatePlanCancellationPolicy
     */
    public $CancellationPolicies;
    /**
     * The Supplements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_HotelRatePlanSupplement
     */
    public $Supplements;
    /**
     * The Offers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_HotelRatePlanOffer
     */
    public $Offers;
    /**
     * The Restrictions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_HotelRatePlanRestriction
     */
    public $Restrictions;
    /**
     * The SpecialNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfArrayOfJPSOAP_HotelRatePlanSpecialNoteText
     */
    public $SpecialNotes;
    /**
     * The ComissionPercent
     * @var float
     */
    public $ComissionPercent;
    /**
     * The ComissionTaxPercent
     * @var float
     */
    public $ComissionTaxPercent;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The ExtranetContract
     * @var bool
     */
    public $ExtranetContract;
    /**
     * The MinimunAge
     * @var int
     */
    public $MinimunAge;
    /**
     * Constructor method for JPSOAP_HotelRatePlanContract
     * @uses JPSOAP_HotelRatePlanContract::setContractType()
     * @uses JPSOAP_HotelRatePlanContract::setComissionable()
     * @uses JPSOAP_HotelRatePlanContract::setRecommendedPrices()
     * @uses JPSOAP_HotelRatePlanContract::setBookingFrom()
     * @uses JPSOAP_HotelRatePlanContract::setBookingTo()
     * @uses JPSOAP_HotelRatePlanContract::setDirectPayment()
     * @uses JPSOAP_HotelRatePlanContract::setApplicationTypeOffer()
     * @uses JPSOAP_HotelRatePlanContract::setAges()
     * @uses JPSOAP_HotelRatePlanContract::setContractRestrictions()
     * @uses JPSOAP_HotelRatePlanContract::setRates()
     * @uses JPSOAP_HotelRatePlanContract::setTaxes()
     * @uses JPSOAP_HotelRatePlanContract::setCancellationPolicies()
     * @uses JPSOAP_HotelRatePlanContract::setSupplements()
     * @uses JPSOAP_HotelRatePlanContract::setOffers()
     * @uses JPSOAP_HotelRatePlanContract::setRestrictions()
     * @uses JPSOAP_HotelRatePlanContract::setSpecialNotes()
     * @uses JPSOAP_HotelRatePlanContract::setComissionPercent()
     * @uses JPSOAP_HotelRatePlanContract::setComissionTaxPercent()
     * @uses JPSOAP_HotelRatePlanContract::setCurrency()
     * @uses JPSOAP_HotelRatePlanContract::setExtranetContract()
     * @uses JPSOAP_HotelRatePlanContract::setMinimunAge()
     * @param string $contractType
     * @param bool $comissionable
     * @param bool $recommendedPrices
     * @param string $bookingFrom
     * @param string $bookingTo
     * @param bool $directPayment
     * @param string $applicationTypeOffer
     * @param \StructType\JPSOAP_Ages $ages
     * @param \StructType\JPSOAP_ContractRestrictions $contractRestrictions
     * @param \ArrayType\ArrayOfJPSOAP_hotelRatePlanRate $rates
     * @param \ArrayType\ArrayOfJPSOAP_hotelRatePlanTax $taxes
     * @param \ArrayType\ArrayOfJPSOAP_hotelRatePlanCancellationPolicy $cancellationPolicies
     * @param \ArrayType\ArrayOfJPSOAP_HotelRatePlanSupplement $supplements
     * @param \ArrayType\ArrayOfJPSOAP_HotelRatePlanOffer $offers
     * @param \ArrayType\ArrayOfJPSOAP_HotelRatePlanRestriction $restrictions
     * @param \ArrayType\ArrayOfArrayOfJPSOAP_HotelRatePlanSpecialNoteText $specialNotes
     * @param float $comissionPercent
     * @param float $comissionTaxPercent
     * @param string $currency
     * @param bool $extranetContract
     * @param int $minimunAge
     */
    public function __construct($contractType = null, $comissionable = null, $recommendedPrices = null, $bookingFrom = null, $bookingTo = null, $directPayment = null, $applicationTypeOffer = null, \StructType\JPSOAP_Ages $ages = null, \StructType\JPSOAP_ContractRestrictions $contractRestrictions = null, \ArrayType\ArrayOfJPSOAP_hotelRatePlanRate $rates = null, \ArrayType\ArrayOfJPSOAP_hotelRatePlanTax $taxes = null, \ArrayType\ArrayOfJPSOAP_hotelRatePlanCancellationPolicy $cancellationPolicies = null, \ArrayType\ArrayOfJPSOAP_HotelRatePlanSupplement $supplements = null, \ArrayType\ArrayOfJPSOAP_HotelRatePlanOffer $offers = null, \ArrayType\ArrayOfJPSOAP_HotelRatePlanRestriction $restrictions = null, \ArrayType\ArrayOfArrayOfJPSOAP_HotelRatePlanSpecialNoteText $specialNotes = null, $comissionPercent = null, $comissionTaxPercent = null, $currency = null, $extranetContract = null, $minimunAge = null)
    {
        $this
            ->setContractType($contractType)
            ->setComissionable($comissionable)
            ->setRecommendedPrices($recommendedPrices)
            ->setBookingFrom($bookingFrom)
            ->setBookingTo($bookingTo)
            ->setDirectPayment($directPayment)
            ->setApplicationTypeOffer($applicationTypeOffer)
            ->setAges($ages)
            ->setContractRestrictions($contractRestrictions)
            ->setRates($rates)
            ->setTaxes($taxes)
            ->setCancellationPolicies($cancellationPolicies)
            ->setSupplements($supplements)
            ->setOffers($offers)
            ->setRestrictions($restrictions)
            ->setSpecialNotes($specialNotes)
            ->setComissionPercent($comissionPercent)
            ->setComissionTaxPercent($comissionTaxPercent)
            ->setCurrency($currency)
            ->setExtranetContract($extranetContract)
            ->setMinimunAge($minimunAge);
    }
    /**
     * Get ContractType value
     * @return string
     */
    public function getContractType()
    {
        return $this->ContractType;
    }
    /**
     * Set ContractType value
     * @uses \EnumType\JPSOAP_ContractType::valueIsValid()
     * @uses \EnumType\JPSOAP_ContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contractType
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setContractType($contractType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_ContractType::valueIsValid($contractType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_ContractType', is_array($contractType) ? implode(', ', $contractType) : var_export($contractType, true), implode(', ', \EnumType\JPSOAP_ContractType::getValidValues())), __LINE__);
        }
        $this->ContractType = $contractType;
        return $this;
    }
    /**
     * Get Comissionable value
     * @return bool
     */
    public function getComissionable()
    {
        return $this->Comissionable;
    }
    /**
     * Set Comissionable value
     * @param bool $comissionable
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setComissionable($comissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($comissionable) && !is_bool($comissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($comissionable, true), gettype($comissionable)), __LINE__);
        }
        $this->Comissionable = $comissionable;
        return $this;
    }
    /**
     * Get RecommendedPrices value
     * @return bool
     */
    public function getRecommendedPrices()
    {
        return $this->RecommendedPrices;
    }
    /**
     * Set RecommendedPrices value
     * @param bool $recommendedPrices
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setRecommendedPrices($recommendedPrices = null)
    {
        // validation for constraint: boolean
        if (!is_null($recommendedPrices) && !is_bool($recommendedPrices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recommendedPrices, true), gettype($recommendedPrices)), __LINE__);
        }
        $this->RecommendedPrices = $recommendedPrices;
        return $this;
    }
    /**
     * Get BookingFrom value
     * @return string
     */
    public function getBookingFrom()
    {
        return $this->BookingFrom;
    }
    /**
     * Set BookingFrom value
     * @param string $bookingFrom
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setBookingFrom($bookingFrom = null)
    {
        // validation for constraint: string
        if (!is_null($bookingFrom) && !is_string($bookingFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingFrom, true), gettype($bookingFrom)), __LINE__);
        }
        $this->BookingFrom = $bookingFrom;
        return $this;
    }
    /**
     * Get BookingTo value
     * @return string
     */
    public function getBookingTo()
    {
        return $this->BookingTo;
    }
    /**
     * Set BookingTo value
     * @param string $bookingTo
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setBookingTo($bookingTo = null)
    {
        // validation for constraint: string
        if (!is_null($bookingTo) && !is_string($bookingTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingTo, true), gettype($bookingTo)), __LINE__);
        }
        $this->BookingTo = $bookingTo;
        return $this;
    }
    /**
     * Get DirectPayment value
     * @return bool
     */
    public function getDirectPayment()
    {
        return $this->DirectPayment;
    }
    /**
     * Set DirectPayment value
     * @param bool $directPayment
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setDirectPayment($directPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($directPayment) && !is_bool($directPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directPayment, true), gettype($directPayment)), __LINE__);
        }
        $this->DirectPayment = $directPayment;
        return $this;
    }
    /**
     * Get ApplicationTypeOffer value
     * @return string
     */
    public function getApplicationTypeOffer()
    {
        return $this->ApplicationTypeOffer;
    }
    /**
     * Set ApplicationTypeOffer value
     * @uses \EnumType\JPSOAP_ApplicationTypeOffer::valueIsValid()
     * @uses \EnumType\JPSOAP_ApplicationTypeOffer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationTypeOffer
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setApplicationTypeOffer($applicationTypeOffer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_ApplicationTypeOffer::valueIsValid($applicationTypeOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_ApplicationTypeOffer', is_array($applicationTypeOffer) ? implode(', ', $applicationTypeOffer) : var_export($applicationTypeOffer, true), implode(', ', \EnumType\JPSOAP_ApplicationTypeOffer::getValidValues())), __LINE__);
        }
        $this->ApplicationTypeOffer = $applicationTypeOffer;
        return $this;
    }
    /**
     * Get Ages value
     * @return \StructType\JPSOAP_Ages|null
     */
    public function getAges()
    {
        return $this->Ages;
    }
    /**
     * Set Ages value
     * @param \StructType\JPSOAP_Ages $ages
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setAges(\StructType\JPSOAP_Ages $ages = null)
    {
        $this->Ages = $ages;
        return $this;
    }
    /**
     * Get ContractRestrictions value
     * @return \StructType\JPSOAP_ContractRestrictions|null
     */
    public function getContractRestrictions()
    {
        return $this->ContractRestrictions;
    }
    /**
     * Set ContractRestrictions value
     * @param \StructType\JPSOAP_ContractRestrictions $contractRestrictions
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setContractRestrictions(\StructType\JPSOAP_ContractRestrictions $contractRestrictions = null)
    {
        $this->ContractRestrictions = $contractRestrictions;
        return $this;
    }
    /**
     * Get Rates value
     * @return \ArrayType\ArrayOfJPSOAP_hotelRatePlanRate|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \ArrayType\ArrayOfJPSOAP_hotelRatePlanRate $rates
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setRates(\ArrayType\ArrayOfJPSOAP_hotelRatePlanRate $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \ArrayType\ArrayOfJPSOAP_hotelRatePlanTax|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \ArrayType\ArrayOfJPSOAP_hotelRatePlanTax $taxes
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setTaxes(\ArrayType\ArrayOfJPSOAP_hotelRatePlanTax $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get CancellationPolicies value
     * @return \ArrayType\ArrayOfJPSOAP_hotelRatePlanCancellationPolicy|null
     */
    public function getCancellationPolicies()
    {
        return $this->CancellationPolicies;
    }
    /**
     * Set CancellationPolicies value
     * @param \ArrayType\ArrayOfJPSOAP_hotelRatePlanCancellationPolicy $cancellationPolicies
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setCancellationPolicies(\ArrayType\ArrayOfJPSOAP_hotelRatePlanCancellationPolicy $cancellationPolicies = null)
    {
        $this->CancellationPolicies = $cancellationPolicies;
        return $this;
    }
    /**
     * Get Supplements value
     * @return \ArrayType\ArrayOfJPSOAP_HotelRatePlanSupplement|null
     */
    public function getSupplements()
    {
        return $this->Supplements;
    }
    /**
     * Set Supplements value
     * @param \ArrayType\ArrayOfJPSOAP_HotelRatePlanSupplement $supplements
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setSupplements(\ArrayType\ArrayOfJPSOAP_HotelRatePlanSupplement $supplements = null)
    {
        $this->Supplements = $supplements;
        return $this;
    }
    /**
     * Get Offers value
     * @return \ArrayType\ArrayOfJPSOAP_HotelRatePlanOffer|null
     */
    public function getOffers()
    {
        return $this->Offers;
    }
    /**
     * Set Offers value
     * @param \ArrayType\ArrayOfJPSOAP_HotelRatePlanOffer $offers
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setOffers(\ArrayType\ArrayOfJPSOAP_HotelRatePlanOffer $offers = null)
    {
        $this->Offers = $offers;
        return $this;
    }
    /**
     * Get Restrictions value
     * @return \ArrayType\ArrayOfJPSOAP_HotelRatePlanRestriction|null
     */
    public function getRestrictions()
    {
        return $this->Restrictions;
    }
    /**
     * Set Restrictions value
     * @param \ArrayType\ArrayOfJPSOAP_HotelRatePlanRestriction $restrictions
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setRestrictions(\ArrayType\ArrayOfJPSOAP_HotelRatePlanRestriction $restrictions = null)
    {
        $this->Restrictions = $restrictions;
        return $this;
    }
    /**
     * Get SpecialNotes value
     * @return \ArrayType\ArrayOfArrayOfJPSOAP_HotelRatePlanSpecialNoteText|null
     */
    public function getSpecialNotes()
    {
        return $this->SpecialNotes;
    }
    /**
     * Set SpecialNotes value
     * @param \ArrayType\ArrayOfArrayOfJPSOAP_HotelRatePlanSpecialNoteText $specialNotes
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setSpecialNotes(\ArrayType\ArrayOfArrayOfJPSOAP_HotelRatePlanSpecialNoteText $specialNotes = null)
    {
        $this->SpecialNotes = $specialNotes;
        return $this;
    }
    /**
     * Get ComissionPercent value
     * @return float|null
     */
    public function getComissionPercent()
    {
        return $this->ComissionPercent;
    }
    /**
     * Set ComissionPercent value
     * @param float $comissionPercent
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setComissionPercent($comissionPercent = null)
    {
        // validation for constraint: float
        if (!is_null($comissionPercent) && !(is_float($comissionPercent) || is_numeric($comissionPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($comissionPercent, true), gettype($comissionPercent)), __LINE__);
        }
        $this->ComissionPercent = $comissionPercent;
        return $this;
    }
    /**
     * Get ComissionTaxPercent value
     * @return float|null
     */
    public function getComissionTaxPercent()
    {
        return $this->ComissionTaxPercent;
    }
    /**
     * Set ComissionTaxPercent value
     * @param float $comissionTaxPercent
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setComissionTaxPercent($comissionTaxPercent = null)
    {
        // validation for constraint: float
        if (!is_null($comissionTaxPercent) && !(is_float($comissionTaxPercent) || is_numeric($comissionTaxPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($comissionTaxPercent, true), gettype($comissionTaxPercent)), __LINE__);
        }
        $this->ComissionTaxPercent = $comissionTaxPercent;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ExtranetContract value
     * @return bool|null
     */
    public function getExtranetContract()
    {
        return $this->ExtranetContract;
    }
    /**
     * Set ExtranetContract value
     * @param bool $extranetContract
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setExtranetContract($extranetContract = null)
    {
        // validation for constraint: boolean
        if (!is_null($extranetContract) && !is_bool($extranetContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extranetContract, true), gettype($extranetContract)), __LINE__);
        }
        $this->ExtranetContract = $extranetContract;
        return $this;
    }
    /**
     * Get MinimunAge value
     * @return int|null
     */
    public function getMinimunAge()
    {
        return $this->MinimunAge;
    }
    /**
     * Set MinimunAge value
     * @param int $minimunAge
     * @return \StructType\JPSOAP_HotelRatePlanContract
     */
    public function setMinimunAge($minimunAge = null)
    {
        // validation for constraint: int
        if (!is_null($minimunAge) && !(is_int($minimunAge) || ctype_digit($minimunAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimunAge, true), gettype($minimunAge)), __LINE__);
        }
        $this->MinimunAge = $minimunAge;
        return $this;
    }
}
