<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageCalendarPriceItems StructType
 * @subpackage Structs
 */
class JP_PackageCalendarPriceItems extends AbstractStructBase
{
    /**
     * The OriginZone
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $OriginZone;
    /**
     * The DestinationZone
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DestinationZone;
    /**
     * The PackageCalendarPriceItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageCalendarPriceItem[]
     */
    public $PackageCalendarPriceItem;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for JP_PackageCalendarPriceItems
     * @uses JP_PackageCalendarPriceItems::setOriginZone()
     * @uses JP_PackageCalendarPriceItems::setDestinationZone()
     * @uses JP_PackageCalendarPriceItems::setPackageCalendarPriceItem()
     * @uses JP_PackageCalendarPriceItems::setCode()
     * @uses JP_PackageCalendarPriceItems::setCurrency()
     * @param int $originZone
     * @param int $destinationZone
     * @param \StructType\JP_PackageCalendarPriceItem[] $packageCalendarPriceItem
     * @param string $code
     * @param string $currency
     */
    public function __construct($originZone = null, $destinationZone = null, array $packageCalendarPriceItem = array(), $code = null, $currency = null)
    {
        $this
            ->setOriginZone($originZone)
            ->setDestinationZone($destinationZone)
            ->setPackageCalendarPriceItem($packageCalendarPriceItem)
            ->setCode($code)
            ->setCurrency($currency);
    }
    /**
     * Get OriginZone value
     * @return int
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_PackageCalendarPriceItems
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !(is_int($originZone) || ctype_digit($originZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_PackageCalendarPriceItems
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !(is_int($destinationZone) || ctype_digit($destinationZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get PackageCalendarPriceItem value
     * @return \StructType\JP_PackageCalendarPriceItem[]|null
     */
    public function getPackageCalendarPriceItem()
    {
        return $this->PackageCalendarPriceItem;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageCalendarPriceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageCalendarPriceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageCalendarPriceItemForArrayConstraintsFromSetPackageCalendarPriceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_PackageCalendarPriceItemsPackageCalendarPriceItemItem) {
            // validation for constraint: itemType
            if (!$jP_PackageCalendarPriceItemsPackageCalendarPriceItemItem instanceof \StructType\JP_PackageCalendarPriceItem) {
                $invalidValues[] = is_object($jP_PackageCalendarPriceItemsPackageCalendarPriceItemItem) ? get_class($jP_PackageCalendarPriceItemsPackageCalendarPriceItemItem) : sprintf('%s(%s)', gettype($jP_PackageCalendarPriceItemsPackageCalendarPriceItemItem), var_export($jP_PackageCalendarPriceItemsPackageCalendarPriceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageCalendarPriceItem property can only contain items of type \StructType\JP_PackageCalendarPriceItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageCalendarPriceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageCalendarPriceItem[] $packageCalendarPriceItem
     * @return \StructType\JP_PackageCalendarPriceItems
     */
    public function setPackageCalendarPriceItem(array $packageCalendarPriceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($packageCalendarPriceItemArrayErrorMessage = self::validatePackageCalendarPriceItemForArrayConstraintsFromSetPackageCalendarPriceItem($packageCalendarPriceItem))) {
            throw new \InvalidArgumentException($packageCalendarPriceItemArrayErrorMessage, __LINE__);
        }
        $this->PackageCalendarPriceItem = $packageCalendarPriceItem;
        return $this;
    }
    /**
     * Add item to PackageCalendarPriceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageCalendarPriceItem $item
     * @return \StructType\JP_PackageCalendarPriceItems
     */
    public function addToPackageCalendarPriceItem(\StructType\JP_PackageCalendarPriceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageCalendarPriceItem) {
            throw new \InvalidArgumentException(sprintf('The PackageCalendarPriceItem property can only contain items of type \StructType\JP_PackageCalendarPriceItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageCalendarPriceItem[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageCalendarPriceItems
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_PackageCalendarPriceItems
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
