<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_MeetingPointListRequest StructType
 * @subpackage Structs
 */
class JP_MeetingPointListRequest extends AbstractStructBase
{
    /**
     * The ZoneCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ZoneCode;
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The Supplier
     * @var string
     */
    public $Supplier;
    /**
     * Constructor method for JP_MeetingPointListRequest
     * @uses JP_MeetingPointListRequest::setZoneCode()
     * @uses JP_MeetingPointListRequest::setProductType()
     * @uses JP_MeetingPointListRequest::setSupplier()
     * @param int $zoneCode
     * @param string $productType
     * @param string $supplier
     */
    public function __construct($zoneCode = null, $productType = null, $supplier = null)
    {
        $this
            ->setZoneCode($zoneCode)
            ->setProductType($productType)
            ->setSupplier($supplier);
    }
    /**
     * Get ZoneCode value
     * @return int
     */
    public function getZoneCode()
    {
        return $this->ZoneCode;
    }
    /**
     * Set ZoneCode value
     * @param int $zoneCode
     * @return \StructType\JP_MeetingPointListRequest
     */
    public function setZoneCode($zoneCode = null)
    {
        // validation for constraint: int
        if (!is_null($zoneCode) && !(is_int($zoneCode) || ctype_digit($zoneCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zoneCode, true), gettype($zoneCode)), __LINE__);
        }
        $this->ZoneCode = $zoneCode;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\JP_MeetingPointListRequest
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \StructType\JP_MeetingPointListRequest
     */
    public function setSupplier($supplier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier) && !is_string($supplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier, true), gettype($supplier)), __LINE__);
        }
        $this->Supplier = $supplier;
        return $this;
    }
}
