<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Package ServiceType
 * @subpackage Services
 */
class Package extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PackageBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for packages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageBooking $parameters
     * @return \StructType\PackageBookingResponse|bool
     */
    public function PackageBooking(\StructType\PackageBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for packages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageAvail $parameters
     * @return \StructType\PackageAvailResponse|bool
     */
    public function PackageAvail(\StructType\PackageAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageChangeProduct
     * Meta information extracted from the WSDL
     * - documentation: Change product for packages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageChangeProduct $parameters
     * @return \StructType\PackageChangeProductResponse|bool
     */
    public function PackageChangeProduct(\StructType\PackageChangeProduct $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageChangeProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageList
     * Meta information extracted from the WSDL
     * - documentation: List of Packages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageList $parameters
     * @return \StructType\PackageListResponse|bool
     */
    public function PackageList(\StructType\PackageList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageCalendarPrice
     * Meta information extracted from the WSDL
     * - documentation: Package calendar price
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageCalendarPrice $parameters
     * @return \StructType\PackageCalendarPriceResponse|bool
     */
    public function PackageCalendarPrice(\StructType\PackageCalendarPrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageCalendarPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageSearcher
     * Meta information extracted from the WSDL
     * - documentation: Various of Packages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageSearcher $parameters
     * @return \StructType\PackageSearcherResponse|bool
     */
    public function PackageSearcher(\StructType\PackageSearcher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageSearcher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageContent
     * Meta information extracted from the WSDL
     * - documentation: Content Of Packages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageContent $parameters
     * @return \StructType\PackageContentResponse|bool
     */
    public function PackageContent(\StructType\PackageContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for packages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageCheckAvail $parameters
     * @return \StructType\PackageCheckAvailResponse|bool
     */
    public function PackageCheckAvail(\StructType\PackageCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules Of Packages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageBookingRules $parameters
     * @return \StructType\PackageBookingRulesResponse|bool
     */
    public function PackageBookingRules(\StructType\PackageBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PackageBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PackageAvailResponse|\StructType\PackageBookingResponse|\StructType\PackageBookingRulesResponse|\StructType\PackageCalendarPriceResponse|\StructType\PackageChangeProductResponse|\StructType\PackageCheckAvailResponse|\StructType\PackageContentResponse|\StructType\PackageListResponse|\StructType\PackageSearcherResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
