<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ServiceOffer ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ServiceOffer extends AbstractStructArrayBase
{
    /**
     * The ServiceOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceOffer[]
     */
    public $ServiceOffer;
    /**
     * Constructor method for ArrayOfJP_ServiceOffer
     * @uses ArrayOfJP_ServiceOffer::setServiceOffer()
     * @param \StructType\JP_ServiceOffer[] $serviceOffer
     */
    public function __construct(array $serviceOffer = array())
    {
        $this
            ->setServiceOffer($serviceOffer);
    }
    /**
     * Get ServiceOffer value
     * @return \StructType\JP_ServiceOffer[]|null
     */
    public function getServiceOffer()
    {
        return $this->ServiceOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceOfferForArrayConstraintsFromSetServiceOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ServiceOfferServiceOfferItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ServiceOfferServiceOfferItem instanceof \StructType\JP_ServiceOffer) {
                $invalidValues[] = is_object($arrayOfJP_ServiceOfferServiceOfferItem) ? get_class($arrayOfJP_ServiceOfferServiceOfferItem) : sprintf('%s(%s)', gettype($arrayOfJP_ServiceOfferServiceOfferItem), var_export($arrayOfJP_ServiceOfferServiceOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceOffer property can only contain items of type \StructType\JP_ServiceOffer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceOffer[] $serviceOffer
     * @return \ArrayType\ArrayOfJP_ServiceOffer
     */
    public function setServiceOffer(array $serviceOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceOfferArrayErrorMessage = self::validateServiceOfferForArrayConstraintsFromSetServiceOffer($serviceOffer))) {
            throw new \InvalidArgumentException($serviceOfferArrayErrorMessage, __LINE__);
        }
        $this->ServiceOffer = $serviceOffer;
        return $this;
    }
    /**
     * Add item to ServiceOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceOffer $item
     * @return \ArrayType\ArrayOfJP_ServiceOffer
     */
    public function addToServiceOffer(\StructType\JP_ServiceOffer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceOffer) {
            throw new \InvalidArgumentException(sprintf('The ServiceOffer property can only contain items of type \StructType\JP_ServiceOffer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceOffer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ServiceOffer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ServiceOffer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ServiceOffer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ServiceOffer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ServiceOffer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceOffer
     */
    public function getAttributeName()
    {
        return 'ServiceOffer';
    }
}
