<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SupplementInfo StructType
 * @subpackage Structs
 */
class JP_SupplementInfo extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Code;
    /**
     * The MeetingPointInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_MeetingPointInfo
     */
    public $MeetingPointInfo;
    /**
     * The FlightInfoOrigin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FlightInfoService
     */
    public $FlightInfoOrigin;
    /**
     * The FlightInfoDestination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FlightInfoService
     */
    public $FlightInfoDestination;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferOrigin
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferDestination
     */
    public $Destination;
    /**
     * The HotelService
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelService
     */
    public $HotelService;
    /**
     * Constructor method for JP_SupplementInfo
     * @uses JP_SupplementInfo::setCode()
     * @uses JP_SupplementInfo::setMeetingPointInfo()
     * @uses JP_SupplementInfo::setFlightInfoOrigin()
     * @uses JP_SupplementInfo::setFlightInfoDestination()
     * @uses JP_SupplementInfo::setOrigin()
     * @uses JP_SupplementInfo::setDestination()
     * @uses JP_SupplementInfo::setHotelService()
     * @param int $code
     * @param \StructType\JP_MeetingPointInfo $meetingPointInfo
     * @param \StructType\JP_FlightInfoService $flightInfoOrigin
     * @param \StructType\JP_FlightInfoService $flightInfoDestination
     * @param \StructType\JP_TransferOrigin $origin
     * @param \StructType\JP_TransferDestination $destination
     * @param \StructType\JP_HotelService $hotelService
     */
    public function __construct($code = null, \StructType\JP_MeetingPointInfo $meetingPointInfo = null, \StructType\JP_FlightInfoService $flightInfoOrigin = null, \StructType\JP_FlightInfoService $flightInfoDestination = null, \StructType\JP_TransferOrigin $origin = null, \StructType\JP_TransferDestination $destination = null, \StructType\JP_HotelService $hotelService = null)
    {
        $this
            ->setCode($code)
            ->setMeetingPointInfo($meetingPointInfo)
            ->setFlightInfoOrigin($flightInfoOrigin)
            ->setFlightInfoDestination($flightInfoDestination)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setHotelService($hotelService);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_SupplementInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get MeetingPointInfo value
     * @return \StructType\JP_MeetingPointInfo|null
     */
    public function getMeetingPointInfo()
    {
        return $this->MeetingPointInfo;
    }
    /**
     * Set MeetingPointInfo value
     * @param \StructType\JP_MeetingPointInfo $meetingPointInfo
     * @return \StructType\JP_SupplementInfo
     */
    public function setMeetingPointInfo(\StructType\JP_MeetingPointInfo $meetingPointInfo = null)
    {
        $this->MeetingPointInfo = $meetingPointInfo;
        return $this;
    }
    /**
     * Get FlightInfoOrigin value
     * @return \StructType\JP_FlightInfoService|null
     */
    public function getFlightInfoOrigin()
    {
        return $this->FlightInfoOrigin;
    }
    /**
     * Set FlightInfoOrigin value
     * @param \StructType\JP_FlightInfoService $flightInfoOrigin
     * @return \StructType\JP_SupplementInfo
     */
    public function setFlightInfoOrigin(\StructType\JP_FlightInfoService $flightInfoOrigin = null)
    {
        $this->FlightInfoOrigin = $flightInfoOrigin;
        return $this;
    }
    /**
     * Get FlightInfoDestination value
     * @return \StructType\JP_FlightInfoService|null
     */
    public function getFlightInfoDestination()
    {
        return $this->FlightInfoDestination;
    }
    /**
     * Set FlightInfoDestination value
     * @param \StructType\JP_FlightInfoService $flightInfoDestination
     * @return \StructType\JP_SupplementInfo
     */
    public function setFlightInfoDestination(\StructType\JP_FlightInfoService $flightInfoDestination = null)
    {
        $this->FlightInfoDestination = $flightInfoDestination;
        return $this;
    }
    /**
     * Get Origin value
     * @return \StructType\JP_TransferOrigin|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param \StructType\JP_TransferOrigin $origin
     * @return \StructType\JP_SupplementInfo
     */
    public function setOrigin(\StructType\JP_TransferOrigin $origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return \StructType\JP_TransferDestination|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param \StructType\JP_TransferDestination $destination
     * @return \StructType\JP_SupplementInfo
     */
    public function setDestination(\StructType\JP_TransferDestination $destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get HotelService value
     * @return \StructType\JP_HotelService|null
     */
    public function getHotelService()
    {
        return $this->HotelService;
    }
    /**
     * Set HotelService value
     * @param \StructType\JP_HotelService $hotelService
     * @return \StructType\JP_SupplementInfo
     */
    public function setHotelService(\StructType\JP_HotelService $hotelService = null)
    {
        $this->HotelService = $hotelService;
        return $this;
    }
}
