<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseSupplement StructType
 * @subpackage Structs
 */
class JP_CruiseSupplement extends AbstractStructBase
{
    /**
     * The Units
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Units;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The RelPaxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CruiseExtendedRelPax
     */
    public $RelPaxes;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_CruiseSupplement
     * @uses JP_CruiseSupplement::setUnits()
     * @uses JP_CruiseSupplement::setType()
     * @uses JP_CruiseSupplement::setName()
     * @uses JP_CruiseSupplement::setDescription()
     * @uses JP_CruiseSupplement::setRelPaxes()
     * @uses JP_CruiseSupplement::setPrices()
     * @uses JP_CruiseSupplement::setRatePlanCode()
     * @param int $units
     * @param string $type
     * @param string $name
     * @param string $description
     * @param \ArrayType\ArrayOfJP_CruiseExtendedRelPax $relPaxes
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $ratePlanCode
     */
    public function __construct($units = null, $type = null, $name = null, $description = null, \ArrayType\ArrayOfJP_CruiseExtendedRelPax $relPaxes = null, \ArrayType\ArrayOfJP_Price $prices = null, $ratePlanCode = null)
    {
        $this
            ->setUnits($units)
            ->setType($type)
            ->setName($name)
            ->setDescription($description)
            ->setRelPaxes($relPaxes)
            ->setPrices($prices)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Units value
     * @return int
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @param int $units
     * @return \StructType\JP_CruiseSupplement
     */
    public function setUnits($units = null)
    {
        // validation for constraint: int
        if (!is_null($units) && !(is_int($units) || ctype_digit($units))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\SuplementsType::valueIsValid()
     * @uses \EnumType\SuplementsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_CruiseSupplement
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SuplementsType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SuplementsType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\SuplementsType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CruiseSupplement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_CruiseSupplement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_CruiseExtendedRelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_CruiseExtendedRelPax $relPaxes
     * @return \StructType\JP_CruiseSupplement
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_CruiseExtendedRelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_CruiseSupplement
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CruiseSupplement
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
}
