<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zone ServiceType
 * @subpackage Services
 */
class Zone extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZoneList
     * Meta information extracted from the WSDL
     * - documentation: Generic Zone List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZoneList $parameters
     * @return \StructType\ZoneListResponse|bool
     */
    public function ZoneList(\StructType\ZoneList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZoneList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZoneListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
