<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Hour ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Hour extends AbstractStructArrayBase
{
    /**
     * The Hour
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Hour[]
     */
    public $Hour;
    /**
     * Constructor method for ArrayOfJP_Hour
     * @uses ArrayOfJP_Hour::setHour()
     * @param \StructType\JP_Hour[] $hour
     */
    public function __construct(array $hour = array())
    {
        $this
            ->setHour($hour);
    }
    /**
     * Get Hour value
     * @return \StructType\JP_Hour[]|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * This method is responsible for validating the values passed to the setHour method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHour method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHourForArrayConstraintsFromSetHour(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_HourHourItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HourHourItem instanceof \StructType\JP_Hour) {
                $invalidValues[] = is_object($arrayOfJP_HourHourItem) ? get_class($arrayOfJP_HourHourItem) : sprintf('%s(%s)', gettype($arrayOfJP_HourHourItem), var_export($arrayOfJP_HourHourItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hour property can only contain items of type \StructType\JP_Hour, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hour value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Hour[] $hour
     * @return \ArrayType\ArrayOfJP_Hour
     */
    public function setHour(array $hour = array())
    {
        // validation for constraint: array
        if ('' !== ($hourArrayErrorMessage = self::validateHourForArrayConstraintsFromSetHour($hour))) {
            throw new \InvalidArgumentException($hourArrayErrorMessage, __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Add item to Hour value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Hour $item
     * @return \ArrayType\ArrayOfJP_Hour
     */
    public function addToHour(\StructType\JP_Hour $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Hour) {
            throw new \InvalidArgumentException(sprintf('The Hour property can only contain items of type \StructType\JP_Hour, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hour[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Hour|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Hour|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Hour|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Hour|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Hour|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Hour
     */
    public function getAttributeName()
    {
        return 'Hour';
    }
}
