<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RoomOccupancy StructType
 * @subpackage Structs
 */
class JP_RoomOccupancy extends AbstractStructBase
{
    /**
     * The Occupancy
     * @var int
     */
    public $Occupancy;
    /**
     * The MaxOccupancy
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The MinOccupancy
     * @var int
     */
    public $MinOccupancy;
    /**
     * The Adults
     * @var int
     */
    public $Adults;
    /**
     * The MaxAdults
     * @var int
     */
    public $MaxAdults;
    /**
     * The MinAdults
     * @var int
     */
    public $MinAdults;
    /**
     * The Children
     * @var int
     */
    public $Children;
    /**
     * The MaxChildren
     * @var int
     */
    public $MaxChildren;
    /**
     * The MinChildren
     * @var int
     */
    public $MinChildren;
    /**
     * Constructor method for JP_RoomOccupancy
     * @uses JP_RoomOccupancy::setOccupancy()
     * @uses JP_RoomOccupancy::setMaxOccupancy()
     * @uses JP_RoomOccupancy::setMinOccupancy()
     * @uses JP_RoomOccupancy::setAdults()
     * @uses JP_RoomOccupancy::setMaxAdults()
     * @uses JP_RoomOccupancy::setMinAdults()
     * @uses JP_RoomOccupancy::setChildren()
     * @uses JP_RoomOccupancy::setMaxChildren()
     * @uses JP_RoomOccupancy::setMinChildren()
     * @param int $occupancy
     * @param int $maxOccupancy
     * @param int $minOccupancy
     * @param int $adults
     * @param int $maxAdults
     * @param int $minAdults
     * @param int $children
     * @param int $maxChildren
     * @param int $minChildren
     */
    public function __construct($occupancy = null, $maxOccupancy = null, $minOccupancy = null, $adults = null, $maxAdults = null, $minAdults = null, $children = null, $maxChildren = null, $minChildren = null)
    {
        $this
            ->setOccupancy($occupancy)
            ->setMaxOccupancy($maxOccupancy)
            ->setMinOccupancy($minOccupancy)
            ->setAdults($adults)
            ->setMaxAdults($maxAdults)
            ->setMinAdults($minAdults)
            ->setChildren($children)
            ->setMaxChildren($maxChildren)
            ->setMinChildren($minChildren);
    }
    /**
     * Get Occupancy value
     * @return int|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @param int $occupancy
     * @return \StructType\JP_RoomOccupancy
     */
    public function setOccupancy($occupancy = null)
    {
        // validation for constraint: int
        if (!is_null($occupancy) && !(is_int($occupancy) || ctype_digit($occupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupancy, true), gettype($occupancy)), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\JP_RoomOccupancy
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get MinOccupancy value
     * @return int|null
     */
    public function getMinOccupancy()
    {
        return $this->MinOccupancy;
    }
    /**
     * Set MinOccupancy value
     * @param int $minOccupancy
     * @return \StructType\JP_RoomOccupancy
     */
    public function setMinOccupancy($minOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minOccupancy) && !(is_int($minOccupancy) || ctype_digit($minOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minOccupancy, true), gettype($minOccupancy)), __LINE__);
        }
        $this->MinOccupancy = $minOccupancy;
        return $this;
    }
    /**
     * Get Adults value
     * @return int|null
     */
    public function getAdults()
    {
        return $this->Adults;
    }
    /**
     * Set Adults value
     * @param int $adults
     * @return \StructType\JP_RoomOccupancy
     */
    public function setAdults($adults = null)
    {
        // validation for constraint: int
        if (!is_null($adults) && !(is_int($adults) || ctype_digit($adults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adults, true), gettype($adults)), __LINE__);
        }
        $this->Adults = $adults;
        return $this;
    }
    /**
     * Get MaxAdults value
     * @return int|null
     */
    public function getMaxAdults()
    {
        return $this->MaxAdults;
    }
    /**
     * Set MaxAdults value
     * @param int $maxAdults
     * @return \StructType\JP_RoomOccupancy
     */
    public function setMaxAdults($maxAdults = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdults) && !(is_int($maxAdults) || ctype_digit($maxAdults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdults, true), gettype($maxAdults)), __LINE__);
        }
        $this->MaxAdults = $maxAdults;
        return $this;
    }
    /**
     * Get MinAdults value
     * @return int|null
     */
    public function getMinAdults()
    {
        return $this->MinAdults;
    }
    /**
     * Set MinAdults value
     * @param int $minAdults
     * @return \StructType\JP_RoomOccupancy
     */
    public function setMinAdults($minAdults = null)
    {
        // validation for constraint: int
        if (!is_null($minAdults) && !(is_int($minAdults) || ctype_digit($minAdults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAdults, true), gettype($minAdults)), __LINE__);
        }
        $this->MinAdults = $minAdults;
        return $this;
    }
    /**
     * Get Children value
     * @return int|null
     */
    public function getChildren()
    {
        return $this->Children;
    }
    /**
     * Set Children value
     * @param int $children
     * @return \StructType\JP_RoomOccupancy
     */
    public function setChildren($children = null)
    {
        // validation for constraint: int
        if (!is_null($children) && !(is_int($children) || ctype_digit($children))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($children, true), gettype($children)), __LINE__);
        }
        $this->Children = $children;
        return $this;
    }
    /**
     * Get MaxChildren value
     * @return int|null
     */
    public function getMaxChildren()
    {
        return $this->MaxChildren;
    }
    /**
     * Set MaxChildren value
     * @param int $maxChildren
     * @return \StructType\JP_RoomOccupancy
     */
    public function setMaxChildren($maxChildren = null)
    {
        // validation for constraint: int
        if (!is_null($maxChildren) && !(is_int($maxChildren) || ctype_digit($maxChildren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChildren, true), gettype($maxChildren)), __LINE__);
        }
        $this->MaxChildren = $maxChildren;
        return $this;
    }
    /**
     * Get MinChildren value
     * @return int|null
     */
    public function getMinChildren()
    {
        return $this->MinChildren;
    }
    /**
     * Set MinChildren value
     * @param int $minChildren
     * @return \StructType\JP_RoomOccupancy
     */
    public function setMinChildren($minChildren = null)
    {
        // validation for constraint: int
        if (!is_null($minChildren) && !(is_int($minChildren) || ctype_digit($minChildren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minChildren, true), gettype($minChildren)), __LINE__);
        }
        $this->MinChildren = $minChildren;
        return $this;
    }
}
