<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_BookingRulesAdvancedOptions StructType
 * @subpackage Structs
 */
abstract class JP_BookingRulesAdvancedOptions extends JP_BaseAdvancedOptions
{
    /**
     * The UseCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UseCurrency;
    /**
     * The ShowOnlyBasicInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowOnlyBasicInfo;
    /**
     * The ChangeFirstDaySupplement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChangeFirstDaySupplement
     */
    public $ChangeFirstDaySupplement;
    /**
     * The ShowBreakdownPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowBreakdownPrice;
    /**
     * Constructor method for JP_BookingRulesAdvancedOptions
     * @uses JP_BookingRulesAdvancedOptions::setUseCurrency()
     * @uses JP_BookingRulesAdvancedOptions::setShowOnlyBasicInfo()
     * @uses JP_BookingRulesAdvancedOptions::setChangeFirstDaySupplement()
     * @uses JP_BookingRulesAdvancedOptions::setShowBreakdownPrice()
     * @param string $useCurrency
     * @param bool $showOnlyBasicInfo
     * @param \StructType\ChangeFirstDaySupplement $changeFirstDaySupplement
     * @param bool $showBreakdownPrice
     */
    public function __construct($useCurrency = null, $showOnlyBasicInfo = null, \StructType\ChangeFirstDaySupplement $changeFirstDaySupplement = null, $showBreakdownPrice = null)
    {
        $this
            ->setUseCurrency($useCurrency)
            ->setShowOnlyBasicInfo($showOnlyBasicInfo)
            ->setChangeFirstDaySupplement($changeFirstDaySupplement)
            ->setShowBreakdownPrice($showBreakdownPrice);
    }
    /**
     * Get UseCurrency value
     * @return string|null
     */
    public function getUseCurrency()
    {
        return $this->UseCurrency;
    }
    /**
     * Set UseCurrency value
     * @param string $useCurrency
     * @return \StructType\JP_BookingRulesAdvancedOptions
     */
    public function setUseCurrency($useCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($useCurrency) && !is_string($useCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useCurrency, true), gettype($useCurrency)), __LINE__);
        }
        $this->UseCurrency = $useCurrency;
        return $this;
    }
    /**
     * Get ShowOnlyBasicInfo value
     * @return bool|null
     */
    public function getShowOnlyBasicInfo()
    {
        return $this->ShowOnlyBasicInfo;
    }
    /**
     * Set ShowOnlyBasicInfo value
     * @param bool $showOnlyBasicInfo
     * @return \StructType\JP_BookingRulesAdvancedOptions
     */
    public function setShowOnlyBasicInfo($showOnlyBasicInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnlyBasicInfo) && !is_bool($showOnlyBasicInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnlyBasicInfo, true), gettype($showOnlyBasicInfo)), __LINE__);
        }
        $this->ShowOnlyBasicInfo = $showOnlyBasicInfo;
        return $this;
    }
    /**
     * Get ChangeFirstDaySupplement value
     * @return \StructType\ChangeFirstDaySupplement|null
     */
    public function getChangeFirstDaySupplement()
    {
        return $this->ChangeFirstDaySupplement;
    }
    /**
     * Set ChangeFirstDaySupplement value
     * @param \StructType\ChangeFirstDaySupplement $changeFirstDaySupplement
     * @return \StructType\JP_BookingRulesAdvancedOptions
     */
    public function setChangeFirstDaySupplement(\StructType\ChangeFirstDaySupplement $changeFirstDaySupplement = null)
    {
        $this->ChangeFirstDaySupplement = $changeFirstDaySupplement;
        return $this;
    }
    /**
     * Get ShowBreakdownPrice value
     * @return bool|null
     */
    public function getShowBreakdownPrice()
    {
        return $this->ShowBreakdownPrice;
    }
    /**
     * Set ShowBreakdownPrice value
     * @param bool $showBreakdownPrice
     * @return \StructType\JP_BookingRulesAdvancedOptions
     */
    public function setShowBreakdownPrice($showBreakdownPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($showBreakdownPrice) && !is_bool($showBreakdownPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showBreakdownPrice, true), gettype($showBreakdownPrice)), __LINE__);
        }
        $this->ShowBreakdownPrice = $showBreakdownPrice;
        return $this;
    }
}
