<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Car StructType
 * @subpackage Structs
 */
class JP_Car extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The RentacarInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarInfo
     */
    public $RentacarInfo;
    /**
     * The PickupOffice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupOffice;
    /**
     * The DropOffOffice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DropOffOffice;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * The SearchMore
     * @var bool
     */
    public $SearchMore;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JP_Car
     * @uses JP_Car::setStart()
     * @uses JP_Car::setEnd()
     * @uses JP_Car::setRentacarInfo()
     * @uses JP_Car::setPickupOffice()
     * @uses JP_Car::setDropOffOffice()
     * @uses JP_Car::setCode()
     * @uses JP_Car::setICode()
     * @uses JP_Car::setSearchMore()
     * @uses JP_Car::setOrder()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @param string $pickupOffice
     * @param string $dropOffOffice
     * @param string $code
     * @param string $iCode
     * @param bool $searchMore
     * @param int $order
     */
    public function __construct($start = null, $end = null, \StructType\JP_RentacarInfo $rentacarInfo = null, $pickupOffice = null, $dropOffOffice = null, $code = null, $iCode = null, $searchMore = null, $order = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setRentacarInfo($rentacarInfo)
            ->setPickupOffice($pickupOffice)
            ->setDropOffOffice($dropOffOffice)
            ->setCode($code)
            ->setICode($iCode)
            ->setSearchMore($searchMore)
            ->setOrder($order);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_Car
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_Car
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get RentacarInfo value
     * @return \StructType\JP_RentacarInfo|null
     */
    public function getRentacarInfo()
    {
        return $this->RentacarInfo;
    }
    /**
     * Set RentacarInfo value
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @return \StructType\JP_Car
     */
    public function setRentacarInfo(\StructType\JP_RentacarInfo $rentacarInfo = null)
    {
        $this->RentacarInfo = $rentacarInfo;
        return $this;
    }
    /**
     * Get PickupOffice value
     * @return string|null
     */
    public function getPickupOffice()
    {
        return $this->PickupOffice;
    }
    /**
     * Set PickupOffice value
     * @param string $pickupOffice
     * @return \StructType\JP_Car
     */
    public function setPickupOffice($pickupOffice = null)
    {
        // validation for constraint: string
        if (!is_null($pickupOffice) && !is_string($pickupOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupOffice, true), gettype($pickupOffice)), __LINE__);
        }
        $this->PickupOffice = $pickupOffice;
        return $this;
    }
    /**
     * Get DropOffOffice value
     * @return string|null
     */
    public function getDropOffOffice()
    {
        return $this->DropOffOffice;
    }
    /**
     * Set DropOffOffice value
     * @param string $dropOffOffice
     * @return \StructType\JP_Car
     */
    public function setDropOffOffice($dropOffOffice = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffOffice) && !is_string($dropOffOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropOffOffice, true), gettype($dropOffOffice)), __LINE__);
        }
        $this->DropOffOffice = $dropOffOffice;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_Car
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_Car
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iCode, true), gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Get SearchMore value
     * @return bool|null
     */
    public function getSearchMore()
    {
        return $this->SearchMore;
    }
    /**
     * Set SearchMore value
     * @param bool $searchMore
     * @return \StructType\JP_Car
     */
    public function setSearchMore($searchMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchMore) && !is_bool($searchMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($searchMore, true), gettype($searchMore)), __LINE__);
        }
        $this->SearchMore = $searchMore;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_Car
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
}
