<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AvailAdvancedOptions StructType
 * @subpackage Structs
 */
abstract class JP_AvailAdvancedOptions extends JP_BaseAdvancedOptions
{
    /**
     * The CalendarSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CalendarSearch;
    /**
     * The UseCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UseCurrency;
    /**
     * The ShowBreakdownPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowBreakdownPrice;
    /**
     * Constructor method for JP_AvailAdvancedOptions
     * @uses JP_AvailAdvancedOptions::setCalendarSearch()
     * @uses JP_AvailAdvancedOptions::setUseCurrency()
     * @uses JP_AvailAdvancedOptions::setShowBreakdownPrice()
     * @param bool $calendarSearch
     * @param string $useCurrency
     * @param bool $showBreakdownPrice
     */
    public function __construct($calendarSearch = null, $useCurrency = null, $showBreakdownPrice = null)
    {
        $this
            ->setCalendarSearch($calendarSearch)
            ->setUseCurrency($useCurrency)
            ->setShowBreakdownPrice($showBreakdownPrice);
    }
    /**
     * Get CalendarSearch value
     * @return bool|null
     */
    public function getCalendarSearch()
    {
        return $this->CalendarSearch;
    }
    /**
     * Set CalendarSearch value
     * @param bool $calendarSearch
     * @return \StructType\JP_AvailAdvancedOptions
     */
    public function setCalendarSearch($calendarSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($calendarSearch) && !is_bool($calendarSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calendarSearch, true), gettype($calendarSearch)), __LINE__);
        }
        $this->CalendarSearch = $calendarSearch;
        return $this;
    }
    /**
     * Get UseCurrency value
     * @return string|null
     */
    public function getUseCurrency()
    {
        return $this->UseCurrency;
    }
    /**
     * Set UseCurrency value
     * @param string $useCurrency
     * @return \StructType\JP_AvailAdvancedOptions
     */
    public function setUseCurrency($useCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($useCurrency) && !is_string($useCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useCurrency, true), gettype($useCurrency)), __LINE__);
        }
        $this->UseCurrency = $useCurrency;
        return $this;
    }
    /**
     * Get ShowBreakdownPrice value
     * @return bool|null
     */
    public function getShowBreakdownPrice()
    {
        return $this->ShowBreakdownPrice;
    }
    /**
     * Set ShowBreakdownPrice value
     * @param bool $showBreakdownPrice
     * @return \StructType\JP_AvailAdvancedOptions
     */
    public function setShowBreakdownPrice($showBreakdownPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($showBreakdownPrice) && !is_bool($showBreakdownPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showBreakdownPrice, true), gettype($showBreakdownPrice)), __LINE__);
        }
        $this->ShowBreakdownPrice = $showBreakdownPrice;
        return $this;
    }
}
