<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelRatePlanSupplement StructType
 * @subpackage Structs
 */
class JPSOAP_HotelRatePlanSupplement extends JPSOAP_BaseSupleOfferRest
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Mandatory
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Mandatory;
    /**
     * The Packaged
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Packaged;
    /**
     * The DirectPayment
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $DirectPayment;
    /**
     * The ApplicationRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_ApplicationRulesSupplement
     */
    public $ApplicationRules;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_SuppleOfferPrices
     */
    public $Prices;
    /**
     * The PickUpPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_PickUpPoint
     */
    public $PickUpPoints;
    /**
     * The BaseBoardCode
     * @var int
     */
    public $BaseBoardCode;
    /**
     * The BaseRoomTypeCode
     * @var int
     */
    public $BaseRoomTypeCode;
    /**
     * The RateCode
     * @var string
     */
    public $RateCode;
    /**
     * The Duration
     * @var int
     */
    public $Duration;
    /**
     * Constructor method for JPSOAP_HotelRatePlanSupplement
     * @uses JPSOAP_HotelRatePlanSupplement::setType()
     * @uses JPSOAP_HotelRatePlanSupplement::setMandatory()
     * @uses JPSOAP_HotelRatePlanSupplement::setPackaged()
     * @uses JPSOAP_HotelRatePlanSupplement::setDirectPayment()
     * @uses JPSOAP_HotelRatePlanSupplement::setApplicationRules()
     * @uses JPSOAP_HotelRatePlanSupplement::setPrices()
     * @uses JPSOAP_HotelRatePlanSupplement::setPickUpPoints()
     * @uses JPSOAP_HotelRatePlanSupplement::setBaseBoardCode()
     * @uses JPSOAP_HotelRatePlanSupplement::setBaseRoomTypeCode()
     * @uses JPSOAP_HotelRatePlanSupplement::setRateCode()
     * @uses JPSOAP_HotelRatePlanSupplement::setDuration()
     * @param string $type
     * @param bool $mandatory
     * @param bool $packaged
     * @param bool $directPayment
     * @param \StructType\JPSOAP_ApplicationRulesSupplement $applicationRules
     * @param \StructType\JPSOAP_SuppleOfferPrices $prices
     * @param \ArrayType\ArrayOfJPSOAP_PickUpPoint $pickUpPoints
     * @param int $baseBoardCode
     * @param int $baseRoomTypeCode
     * @param string $rateCode
     * @param int $duration
     */
    public function __construct($type = null, $mandatory = null, $packaged = null, $directPayment = null, \StructType\JPSOAP_ApplicationRulesSupplement $applicationRules = null, \StructType\JPSOAP_SuppleOfferPrices $prices = null, \ArrayType\ArrayOfJPSOAP_PickUpPoint $pickUpPoints = null, $baseBoardCode = null, $baseRoomTypeCode = null, $rateCode = null, $duration = null)
    {
        $this
            ->setType($type)
            ->setMandatory($mandatory)
            ->setPackaged($packaged)
            ->setDirectPayment($directPayment)
            ->setApplicationRules($applicationRules)
            ->setPrices($prices)
            ->setPickUpPoints($pickUpPoints)
            ->setBaseBoardCode($baseBoardCode)
            ->setBaseRoomTypeCode($baseRoomTypeCode)
            ->setRateCode($rateCode)
            ->setDuration($duration);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JPSOAP_SupplementType::valueIsValid()
     * @uses \EnumType\JPSOAP_SupplementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_SupplementType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_SupplementType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JPSOAP_SupplementType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Mandatory value
     * @return bool
     */
    public function getMandatory()
    {
        return $this->Mandatory;
    }
    /**
     * Set Mandatory value
     * @param bool $mandatory
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatory, true), gettype($mandatory)), __LINE__);
        }
        $this->Mandatory = $mandatory;
        return $this;
    }
    /**
     * Get Packaged value
     * @return bool
     */
    public function getPackaged()
    {
        return $this->Packaged;
    }
    /**
     * Set Packaged value
     * @param bool $packaged
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setPackaged($packaged = null)
    {
        // validation for constraint: boolean
        if (!is_null($packaged) && !is_bool($packaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($packaged, true), gettype($packaged)), __LINE__);
        }
        $this->Packaged = $packaged;
        return $this;
    }
    /**
     * Get DirectPayment value
     * @return bool
     */
    public function getDirectPayment()
    {
        return $this->DirectPayment;
    }
    /**
     * Set DirectPayment value
     * @param bool $directPayment
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setDirectPayment($directPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($directPayment) && !is_bool($directPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directPayment, true), gettype($directPayment)), __LINE__);
        }
        $this->DirectPayment = $directPayment;
        return $this;
    }
    /**
     * Get ApplicationRules value
     * @return \StructType\JPSOAP_ApplicationRulesSupplement|null
     */
    public function getApplicationRules()
    {
        return $this->ApplicationRules;
    }
    /**
     * Set ApplicationRules value
     * @param \StructType\JPSOAP_ApplicationRulesSupplement $applicationRules
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setApplicationRules(\StructType\JPSOAP_ApplicationRulesSupplement $applicationRules = null)
    {
        $this->ApplicationRules = $applicationRules;
        return $this;
    }
    /**
     * Get Prices value
     * @return \StructType\JPSOAP_SuppleOfferPrices|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \StructType\JPSOAP_SuppleOfferPrices $prices
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setPrices(\StructType\JPSOAP_SuppleOfferPrices $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get PickUpPoints value
     * @return \ArrayType\ArrayOfJPSOAP_PickUpPoint|null
     */
    public function getPickUpPoints()
    {
        return $this->PickUpPoints;
    }
    /**
     * Set PickUpPoints value
     * @param \ArrayType\ArrayOfJPSOAP_PickUpPoint $pickUpPoints
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setPickUpPoints(\ArrayType\ArrayOfJPSOAP_PickUpPoint $pickUpPoints = null)
    {
        $this->PickUpPoints = $pickUpPoints;
        return $this;
    }
    /**
     * Get BaseBoardCode value
     * @return int|null
     */
    public function getBaseBoardCode()
    {
        return $this->BaseBoardCode;
    }
    /**
     * Set BaseBoardCode value
     * @param int $baseBoardCode
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setBaseBoardCode($baseBoardCode = null)
    {
        // validation for constraint: int
        if (!is_null($baseBoardCode) && !(is_int($baseBoardCode) || ctype_digit($baseBoardCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baseBoardCode, true), gettype($baseBoardCode)), __LINE__);
        }
        $this->BaseBoardCode = $baseBoardCode;
        return $this;
    }
    /**
     * Get BaseRoomTypeCode value
     * @return int|null
     */
    public function getBaseRoomTypeCode()
    {
        return $this->BaseRoomTypeCode;
    }
    /**
     * Set BaseRoomTypeCode value
     * @param int $baseRoomTypeCode
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setBaseRoomTypeCode($baseRoomTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($baseRoomTypeCode) && !(is_int($baseRoomTypeCode) || ctype_digit($baseRoomTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baseRoomTypeCode, true), gettype($baseRoomTypeCode)), __LINE__);
        }
        $this->BaseRoomTypeCode = $baseRoomTypeCode;
        return $this;
    }
    /**
     * Get RateCode value
     * @return string|null
     */
    public function getRateCode()
    {
        return $this->RateCode;
    }
    /**
     * Set RateCode value
     * @param string $rateCode
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setRateCode($rateCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateCode) && !is_string($rateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateCode, true), gettype($rateCode)), __LINE__);
        }
        $this->RateCode = $rateCode;
        return $this;
    }
    /**
     * Get Duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\JPSOAP_HotelRatePlanSupplement
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
}
