<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_BookingListRequest StructType
 * @subpackage Structs
 */
class JP_BookingListRequest extends AbstractStructBase
{
    /**
     * The StartingBookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StartingBookingDate
     */
    public $StartingBookingDate;
    /**
     * The CancellationBookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancellationBookingDate
     */
    public $CancellationBookingDate;
    /**
     * The ModificationBookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ModificationBookingDate
     */
    public $ModificationBookingDate;
    /**
     * The BookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingDate
     */
    public $BookingDate;
    /**
     * The ExternalBookingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * Constructor method for JP_BookingListRequest
     * @uses JP_BookingListRequest::setStartingBookingDate()
     * @uses JP_BookingListRequest::setCancellationBookingDate()
     * @uses JP_BookingListRequest::setModificationBookingDate()
     * @uses JP_BookingListRequest::setBookingDate()
     * @uses JP_BookingListRequest::setExternalBookingReference()
     * @param \StructType\StartingBookingDate $startingBookingDate
     * @param \StructType\CancellationBookingDate $cancellationBookingDate
     * @param \StructType\ModificationBookingDate $modificationBookingDate
     * @param \StructType\BookingDate $bookingDate
     * @param string $externalBookingReference
     */
    public function __construct(\StructType\StartingBookingDate $startingBookingDate = null, \StructType\CancellationBookingDate $cancellationBookingDate = null, \StructType\ModificationBookingDate $modificationBookingDate = null, \StructType\BookingDate $bookingDate = null, $externalBookingReference = null)
    {
        $this
            ->setStartingBookingDate($startingBookingDate)
            ->setCancellationBookingDate($cancellationBookingDate)
            ->setModificationBookingDate($modificationBookingDate)
            ->setBookingDate($bookingDate)
            ->setExternalBookingReference($externalBookingReference);
    }
    /**
     * Get StartingBookingDate value
     * @return \StructType\StartingBookingDate|null
     */
    public function getStartingBookingDate()
    {
        return $this->StartingBookingDate;
    }
    /**
     * Set StartingBookingDate value
     * @param \StructType\StartingBookingDate $startingBookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setStartingBookingDate(\StructType\StartingBookingDate $startingBookingDate = null)
    {
        $this->StartingBookingDate = $startingBookingDate;
        return $this;
    }
    /**
     * Get CancellationBookingDate value
     * @return \StructType\CancellationBookingDate|null
     */
    public function getCancellationBookingDate()
    {
        return $this->CancellationBookingDate;
    }
    /**
     * Set CancellationBookingDate value
     * @param \StructType\CancellationBookingDate $cancellationBookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setCancellationBookingDate(\StructType\CancellationBookingDate $cancellationBookingDate = null)
    {
        $this->CancellationBookingDate = $cancellationBookingDate;
        return $this;
    }
    /**
     * Get ModificationBookingDate value
     * @return \StructType\ModificationBookingDate|null
     */
    public function getModificationBookingDate()
    {
        return $this->ModificationBookingDate;
    }
    /**
     * Set ModificationBookingDate value
     * @param \StructType\ModificationBookingDate $modificationBookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setModificationBookingDate(\StructType\ModificationBookingDate $modificationBookingDate = null)
    {
        $this->ModificationBookingDate = $modificationBookingDate;
        return $this;
    }
    /**
     * Get BookingDate value
     * @return \StructType\BookingDate|null
     */
    public function getBookingDate()
    {
        return $this->BookingDate;
    }
    /**
     * Set BookingDate value
     * @param \StructType\BookingDate $bookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setBookingDate(\StructType\BookingDate $bookingDate = null)
    {
        $this->BookingDate = $bookingDate;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\JP_BookingListRequest
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingReference, true), gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
}
