<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_TransferElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_TransferElement extends AbstractStructArrayBase
{
    /**
     * The TransferElement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransferElement[]
     */
    public $TransferElement;
    /**
     * Constructor method for ArrayOfJP_TransferElement
     * @uses ArrayOfJP_TransferElement::setTransferElement()
     * @param \StructType\JP_TransferElement[] $transferElement
     */
    public function __construct(array $transferElement = array())
    {
        $this
            ->setTransferElement($transferElement);
    }
    /**
     * Get TransferElement value
     * @return \StructType\JP_TransferElement[]|null
     */
    public function getTransferElement()
    {
        return $this->TransferElement;
    }
    /**
     * This method is responsible for validating the values passed to the setTransferElement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransferElement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransferElementForArrayConstraintsFromSetTransferElement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_TransferElementTransferElementItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_TransferElementTransferElementItem instanceof \StructType\JP_TransferElement) {
                $invalidValues[] = is_object($arrayOfJP_TransferElementTransferElementItem) ? get_class($arrayOfJP_TransferElementTransferElementItem) : sprintf('%s(%s)', gettype($arrayOfJP_TransferElementTransferElementItem), var_export($arrayOfJP_TransferElementTransferElementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransferElement property can only contain items of type \StructType\JP_TransferElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransferElement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferElement[] $transferElement
     * @return \ArrayType\ArrayOfJP_TransferElement
     */
    public function setTransferElement(array $transferElement = array())
    {
        // validation for constraint: array
        if ('' !== ($transferElementArrayErrorMessage = self::validateTransferElementForArrayConstraintsFromSetTransferElement($transferElement))) {
            throw new \InvalidArgumentException($transferElementArrayErrorMessage, __LINE__);
        }
        $this->TransferElement = $transferElement;
        return $this;
    }
    /**
     * Add item to TransferElement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferElement $item
     * @return \ArrayType\ArrayOfJP_TransferElement
     */
    public function addToTransferElement(\StructType\JP_TransferElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransferElement) {
            throw new \InvalidArgumentException(sprintf('The TransferElement property can only contain items of type \StructType\JP_TransferElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransferElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_TransferElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_TransferElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_TransferElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_TransferElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_TransferElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransferElement
     */
    public function getAttributeName()
    {
        return 'TransferElement';
    }
}
