<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Warnings StructType
 * @subpackage Structs
 */
class JP_Warnings extends AbstractStructBase
{
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_WarningType[]
     */
    public $Warning;
    /**
     * The CancelInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CancelInformation[]
     */
    public $CancelInfo;
    /**
     * Constructor method for JP_Warnings
     * @uses JP_Warnings::setWarning()
     * @uses JP_Warnings::setCancelInfo()
     * @param \StructType\JP_WarningType[] $warning
     * @param \StructType\JP_CancelInformation[] $cancelInfo
     */
    public function __construct(array $warning = array(), array $cancelInfo = array())
    {
        $this
            ->setWarning($warning)
            ->setCancelInfo($cancelInfo);
    }
    /**
     * Get Warning value
     * @return \StructType\JP_WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_WarningsWarningItem) {
            // validation for constraint: itemType
            if (!$jP_WarningsWarningItem instanceof \StructType\JP_WarningType) {
                $invalidValues[] = is_object($jP_WarningsWarningItem) ? get_class($jP_WarningsWarningItem) : sprintf('%s(%s)', gettype($jP_WarningsWarningItem), var_export($jP_WarningsWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\JP_WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_WarningType[] $warning
     * @return \StructType\JP_Warnings
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_WarningType $item
     * @return \StructType\JP_Warnings
     */
    public function addToWarning(\StructType\JP_WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\JP_WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
    /**
     * Get CancelInfo value
     * @return \StructType\JP_CancelInformation[]|null
     */
    public function getCancelInfo()
    {
        return $this->CancelInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelInfoForArrayConstraintsFromSetCancelInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_WarningsCancelInfoItem) {
            // validation for constraint: itemType
            if (!$jP_WarningsCancelInfoItem instanceof \StructType\JP_CancelInformation) {
                $invalidValues[] = is_object($jP_WarningsCancelInfoItem) ? get_class($jP_WarningsCancelInfoItem) : sprintf('%s(%s)', gettype($jP_WarningsCancelInfoItem), var_export($jP_WarningsCancelInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelInfo property can only contain items of type \StructType\JP_CancelInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CancelInformation[] $cancelInfo
     * @return \StructType\JP_Warnings
     */
    public function setCancelInfo(array $cancelInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelInfoArrayErrorMessage = self::validateCancelInfoForArrayConstraintsFromSetCancelInfo($cancelInfo))) {
            throw new \InvalidArgumentException($cancelInfoArrayErrorMessage, __LINE__);
        }
        $this->CancelInfo = $cancelInfo;
        return $this;
    }
    /**
     * Add item to CancelInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CancelInformation $item
     * @return \StructType\JP_Warnings
     */
    public function addToCancelInfo(\StructType\JP_CancelInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CancelInformation) {
            throw new \InvalidArgumentException(sprintf('The CancelInfo property can only contain items of type \StructType\JP_CancelInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelInfo[] = $item;
        return $this;
    }
}
