<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PaymentReservation StructType
 * @subpackage Structs
 */
class JP_PaymentReservation extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PaymentInfo
     */
    public $PaymentInfo;
    /**
     * The Locator
     * @var string
     */
    public $Locator;
    /**
     * Constructor method for JP_PaymentReservation
     * @uses JP_PaymentReservation::setStatus()
     * @uses JP_PaymentReservation::setPaymentInfo()
     * @uses JP_PaymentReservation::setLocator()
     * @param string $status
     * @param \StructType\JP_PaymentInfo $paymentInfo
     * @param string $locator
     */
    public function __construct($status = null, \StructType\JP_PaymentInfo $paymentInfo = null, $locator = null)
    {
        $this
            ->setStatus($status)
            ->setPaymentInfo($paymentInfo)
            ->setLocator($locator);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_ResStatus::valueIsValid()
     * @uses \EnumType\JP_ResStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_PaymentReservation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ResStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ResStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_ResStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \StructType\JP_PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \StructType\JP_PaymentInfo $paymentInfo
     * @return \StructType\JP_PaymentReservation
     */
    public function setPaymentInfo(\StructType\JP_PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get Locator value
     * @return string|null
     */
    public function getLocator()
    {
        return $this->Locator;
    }
    /**
     * Set Locator value
     * @param string $locator
     * @return \StructType\JP_PaymentReservation
     */
    public function setLocator($locator = null)
    {
        // validation for constraint: string
        if (!is_null($locator) && !is_string($locator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locator, true), gettype($locator)), __LINE__);
        }
        $this->Locator = $locator;
        return $this;
    }
}
