<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_DailyHotelContract StructType
 * @subpackage Structs
 */
class JP_DailyHotelContract extends JP_Contract
{
    /**
     * The StayDate
     * @var string
     */
    public $StayDate;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_DailyHotelContract
     * @uses JP_DailyHotelContract::setStayDate()
     * @uses JP_DailyHotelContract::setCode()
     * @param string $stayDate
     * @param string $code
     */
    public function __construct($stayDate = null, $code = null)
    {
        $this
            ->setStayDate($stayDate)
            ->setCode($code);
    }
    /**
     * Get StayDate value
     * @return string|null
     */
    public function getStayDate()
    {
        return $this->StayDate;
    }
    /**
     * Set StayDate value
     * @param string $stayDate
     * @return \StructType\JP_DailyHotelContract
     */
    public function setStayDate($stayDate = null)
    {
        // validation for constraint: string
        if (!is_null($stayDate) && !is_string($stayDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stayDate, true), gettype($stayDate)), __LINE__);
        }
        $this->StayDate = $stayDate;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_DailyHotelContract
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
