<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageOptionChangeProduct StructType
 * @subpackage Structs
 */
class JP_PackageOptionChangeProduct extends JP_PackageOptionRQ
{
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * Constructor method for JP_PackageOptionChangeProduct
     * @uses JP_PackageOptionChangeProduct::setProductType()
     * @uses JP_PackageOptionChangeProduct::setICode()
     * @param string $productType
     * @param string $iCode
     */
    public function __construct($productType = null, $iCode = null)
    {
        $this
            ->setProductType($productType)
            ->setICode($iCode);
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\JP_PackageOptionChangeProduct
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_PackageOptionChangeProduct
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iCode, true), gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
}
