<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_RoomCategory ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_RoomCategory extends AbstractStructArrayBase
{
    /**
     * The RoomCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RoomCategory[]
     */
    public $RoomCategory;
    /**
     * Constructor method for ArrayOfJP_RoomCategory
     * @uses ArrayOfJP_RoomCategory::setRoomCategory()
     * @param \StructType\JP_RoomCategory[] $roomCategory
     */
    public function __construct(array $roomCategory = array())
    {
        $this
            ->setRoomCategory($roomCategory);
    }
    /**
     * Get RoomCategory value
     * @return \StructType\JP_RoomCategory[]|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomCategoryForArrayConstraintsFromSetRoomCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_RoomCategoryRoomCategoryItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_RoomCategoryRoomCategoryItem instanceof \StructType\JP_RoomCategory) {
                $invalidValues[] = is_object($arrayOfJP_RoomCategoryRoomCategoryItem) ? get_class($arrayOfJP_RoomCategoryRoomCategoryItem) : sprintf('%s(%s)', gettype($arrayOfJP_RoomCategoryRoomCategoryItem), var_export($arrayOfJP_RoomCategoryRoomCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomCategory property can only contain items of type \StructType\JP_RoomCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RoomCategory[] $roomCategory
     * @return \ArrayType\ArrayOfJP_RoomCategory
     */
    public function setRoomCategory(array $roomCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($roomCategoryArrayErrorMessage = self::validateRoomCategoryForArrayConstraintsFromSetRoomCategory($roomCategory))) {
            throw new \InvalidArgumentException($roomCategoryArrayErrorMessage, __LINE__);
        }
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Add item to RoomCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RoomCategory $item
     * @return \ArrayType\ArrayOfJP_RoomCategory
     */
    public function addToRoomCategory(\StructType\JP_RoomCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RoomCategory) {
            throw new \InvalidArgumentException(sprintf('The RoomCategory property can only contain items of type \StructType\JP_RoomCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomCategory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_RoomCategory|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_RoomCategory|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_RoomCategory|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_RoomCategory|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_RoomCategory|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomCategory
     */
    public function getAttributeName()
    {
        return 'RoomCategory';
    }
}
