<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_BookingListRSReservation ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_BookingListRSReservation extends AbstractStructArrayBase
{
    /**
     * The Reservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Reservation[]
     */
    public $Reservation;
    /**
     * Constructor method for ArrayOfJP_BookingListRSReservation
     * @uses ArrayOfJP_BookingListRSReservation::setReservation()
     * @param \StructType\Reservation[] $reservation
     */
    public function __construct(array $reservation = array())
    {
        $this
            ->setReservation($reservation);
    }
    /**
     * Get Reservation value
     * @return \StructType\Reservation[]|null
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * This method is responsible for validating the values passed to the setReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationForArrayConstraintsFromSetReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_BookingListRSReservationReservationItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_BookingListRSReservationReservationItem instanceof \StructType\Reservation) {
                $invalidValues[] = is_object($arrayOfJP_BookingListRSReservationReservationItem) ? get_class($arrayOfJP_BookingListRSReservationReservationItem) : sprintf('%s(%s)', gettype($arrayOfJP_BookingListRSReservationReservationItem), var_export($arrayOfJP_BookingListRSReservationReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reservation property can only contain items of type \StructType\Reservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reservation value
     * @throws \InvalidArgumentException
     * @param \StructType\Reservation[] $reservation
     * @return \ArrayType\ArrayOfJP_BookingListRSReservation
     */
    public function setReservation(array $reservation = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationArrayErrorMessage = self::validateReservationForArrayConstraintsFromSetReservation($reservation))) {
            throw new \InvalidArgumentException($reservationArrayErrorMessage, __LINE__);
        }
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Add item to Reservation value
     * @throws \InvalidArgumentException
     * @param \StructType\Reservation $item
     * @return \ArrayType\ArrayOfJP_BookingListRSReservation
     */
    public function addToReservation(\StructType\Reservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Reservation) {
            throw new \InvalidArgumentException(sprintf('The Reservation property can only contain items of type \StructType\Reservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reservation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Reservation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Reservation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Reservation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Reservation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Reservation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Reservation
     */
    public function getAttributeName()
    {
        return 'Reservation';
    }
}
