<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hotel ServiceType
 * @subpackage Services
 */
class Hotel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HotelBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for hotels.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelBooking $parameters
     * @return \StructType\HotelBookingResponse|bool
     */
    public function HotelBooking(\StructType\HotelBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelModify
     * Meta information extracted from the WSDL
     * - documentation: Modify for hotels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelModify $parameters
     * @return \StructType\HotelModifyResponse|bool
     */
    public function HotelModify(\StructType\HotelModify $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelModify($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelConfirmModify
     * Meta information extracted from the WSDL
     * - documentation: ConfirmModify for hotels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelConfirmModify $parameters
     * @return \StructType\HotelConfirmModifyResponse|bool
     */
    public function HotelConfirmModify(\StructType\HotelConfirmModify $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelConfirmModify($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for hotels.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelAvail $parameters
     * @return \StructType\HotelAvailResponse|bool
     */
    public function HotelAvail(\StructType\HotelAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelAvailCalendar
     * Meta information extracted from the WSDL
     * - documentation: Availability calendar for hotels.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelAvailCalendar $parameters
     * @return \StructType\HotelAvailCalendarResponse|bool
     */
    public function HotelAvailCalendar(\StructType\HotelAvailCalendar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelAvailCalendar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelFutureRates
     * Meta information extracted from the WSDL
     * - documentation: Future rates for hotels.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelFutureRates $parameters
     * @return \StructType\HotelFutureRatesResponse|bool
     */
    public function HotelFutureRates(\StructType\HotelFutureRates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelFutureRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelAllotment
     * Meta information extracted from the WSDL
     * - documentation: Hotel Allotment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelAllotment $parameters
     * @return \StructType\HotelAllotmentResponse|bool
     */
    public function HotelAllotment(\StructType\HotelAllotment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelAllotment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelRates
     * Meta information extracted from the WSDL
     * - documentation: Hotel Rates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelRates $parameters
     * @return \StructType\HotelRatesResponse|bool
     */
    public function HotelRates(\StructType\HotelRates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelSpecifications
     * Meta information extracted from the WSDL
     * - documentation: Hotel Specifications
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelSpecifications $parameters
     * @return \StructType\HotelSpecificationsResponse|bool
     */
    public function HotelSpecifications(\StructType\HotelSpecifications $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelSpecifications($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelListInventory
     * Meta information extracted from the WSDL
     * - documentation: Hotel List Inventory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelListInventory $parameters
     * @return \StructType\HotelListInventoryResponse|bool
     */
    public function HotelListInventory(\StructType\HotelListInventory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelListInventory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelCatalogueData
     * Meta information extracted from the WSDL
     * - documentation: Catalogue For Hotels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelCatalogueData $parameters
     * @return \StructType\HotelCatalogueDataResponse|bool
     */
    public function HotelCatalogueData(\StructType\HotelCatalogueData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelCatalogueData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelList
     * Meta information extracted from the WSDL
     * - documentation: List of Hotels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelList $parameters
     * @return \StructType\HotelListResponse|bool
     */
    public function HotelList(\StructType\HotelList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelPortfolio
     * Meta information extracted from the WSDL
     * - documentation: Paged Portfolio of Hotels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelPortfolio $parameters
     * @return \StructType\HotelPortfolioResponse|bool
     */
    public function HotelPortfolio(\StructType\HotelPortfolio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelPortfolio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelContent
     * Meta information extracted from the WSDL
     * - documentation: Content Of Hotels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelContent $parameters
     * @return \StructType\HotelContentResponse|bool
     */
    public function HotelContent(\StructType\HotelContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for hotels.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelCheckAvail $parameters
     * @return \StructType\HotelCheckAvailResponse|bool
     */
    public function HotelCheckAvail(\StructType\HotelCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules Of Hotels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelBookingRules $parameters
     * @return \StructType\HotelBookingRulesResponse|bool
     */
    public function HotelBookingRules(\StructType\HotelBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HotelAllotmentResponse|\StructType\HotelAvailCalendarResponse|\StructType\HotelAvailResponse|\StructType\HotelBookingResponse|\StructType\HotelBookingRulesResponse|\StructType\HotelCatalogueDataResponse|\StructType\HotelCheckAvailResponse|\StructType\HotelConfirmModifyResponse|\StructType\HotelContentResponse|\StructType\HotelFutureRatesResponse|\StructType\HotelListInventoryResponse|\StructType\HotelListResponse|\StructType\HotelModifyResponse|\StructType\HotelPortfolioResponse|\StructType\HotelRatesResponse|\StructType\HotelSpecificationsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
