<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelBooking
     * Meta information extracted from the WSDL
     * - documentation: cancel process for bookings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelBooking $parameters
     * @return \StructType\CancelBookingResponse|bool
     */
    public function CancelBooking(\StructType\CancelBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelBookingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
