<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelDailyContracts StructType
 * @subpackage Structs
 */
class JP_HotelDailyContracts extends AbstractStructBase
{
    /**
     * The DailyContract
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelDailyContract[]
     */
    public $DailyContract;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for JP_HotelDailyContracts
     * @uses JP_HotelDailyContracts::setDailyContract()
     * @uses JP_HotelDailyContracts::setType()
     * @param \StructType\JP_HotelDailyContract[] $dailyContract
     * @param string $type
     */
    public function __construct(array $dailyContract = array(), $type = null)
    {
        $this
            ->setDailyContract($dailyContract)
            ->setType($type);
    }
    /**
     * Get DailyContract value
     * @return \StructType\JP_HotelDailyContract[]|null
     */
    public function getDailyContract()
    {
        return $this->DailyContract;
    }
    /**
     * Set DailyContract value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelDailyContract[] $dailyContract
     * @return \StructType\JP_HotelDailyContracts
     */
    public function setDailyContract(array $dailyContract = array())
    {
        foreach ($dailyContract as $jP_HotelDailyContractsDailyContractItem) {
            // validation for constraint: itemType
            if (!$jP_HotelDailyContractsDailyContractItem instanceof \StructType\JP_HotelDailyContract) {
                throw new \InvalidArgumentException(sprintf('The DailyContract property can only contain items of \StructType\JP_HotelDailyContract, "%s" given', is_object($jP_HotelDailyContractsDailyContractItem) ? get_class($jP_HotelDailyContractsDailyContractItem) : gettype($jP_HotelDailyContractsDailyContractItem)), __LINE__);
            }
        }
        $this->DailyContract = $dailyContract;
        return $this;
    }
    /**
     * Add item to DailyContract value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelDailyContract $item
     * @return \StructType\JP_HotelDailyContracts
     */
    public function addToDailyContract(\StructType\JP_HotelDailyContract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelDailyContract) {
            throw new \InvalidArgumentException(sprintf('The DailyContract property can only contain items of \StructType\JP_HotelDailyContract, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DailyContract[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_HotelDailyContracts
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelDailyContracts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
