<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString3 extends AbstractStructArrayBase
{
    /**
     * The Situation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Situation;
    /**
     * Constructor method for ArrayOfString3
     * @uses ArrayOfString3::setSituation()
     * @param string[] $situation
     */
    public function __construct(array $situation = array())
    {
        $this
            ->setSituation($situation);
    }
    /**
     * Get Situation value
     * @return string[]|null
     */
    public function getSituation()
    {
        return $this->Situation;
    }
    /**
     * Set Situation value
     * @throws \InvalidArgumentException
     * @param string[] $situation
     * @return \ArrayType\ArrayOfString3
     */
    public function setSituation(array $situation = array())
    {
        foreach ($situation as $arrayOfString3SituationItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString3SituationItem)) {
                throw new \InvalidArgumentException(sprintf('The Situation property can only contain items of string, "%s" given', is_object($arrayOfString3SituationItem) ? get_class($arrayOfString3SituationItem) : gettype($arrayOfString3SituationItem)), __LINE__);
            }
        }
        $this->Situation = $situation;
        return $this;
    }
    /**
     * Add item to Situation value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString3
     */
    public function addToSituation($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Situation property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Situation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Situation
     */
    public function getAttributeName()
    {
        return 'Situation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
