<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelRatesRS StructType
 * @subpackage Structs
 */
class JP_HotelRatesRS extends AbstractStructBase
{
    /**
     * The Contract
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelRatePlanContract[]
     */
    public $Contract;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCodeEncrypt
     * @var string
     */
    public $HotelCodeEncrypt;
    /**
     * Constructor method for JP_HotelRatesRS
     * @uses JP_HotelRatesRS::setContract()
     * @uses JP_HotelRatesRS::setHotelCode()
     * @uses JP_HotelRatesRS::setHotelCodeEncrypt()
     * @param \StructType\JPSOAP_HotelRatePlanContract[] $contract
     * @param string $hotelCode
     * @param string $hotelCodeEncrypt
     */
    public function __construct(array $contract = array(), $hotelCode = null, $hotelCodeEncrypt = null)
    {
        $this
            ->setContract($contract)
            ->setHotelCode($hotelCode)
            ->setHotelCodeEncrypt($hotelCodeEncrypt);
    }
    /**
     * Get Contract value
     * @return \StructType\JPSOAP_HotelRatePlanContract[]|null
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * Set Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelRatePlanContract[] $contract
     * @return \StructType\JP_HotelRatesRS
     */
    public function setContract(array $contract = array())
    {
        foreach ($contract as $jP_HotelRatesRSContractItem) {
            // validation for constraint: itemType
            if (!$jP_HotelRatesRSContractItem instanceof \StructType\JPSOAP_HotelRatePlanContract) {
                throw new \InvalidArgumentException(sprintf('The Contract property can only contain items of \StructType\JPSOAP_HotelRatePlanContract, "%s" given', is_object($jP_HotelRatesRSContractItem) ? get_class($jP_HotelRatesRSContractItem) : gettype($jP_HotelRatesRSContractItem)), __LINE__);
            }
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Add item to Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelRatePlanContract $item
     * @return \StructType\JP_HotelRatesRS
     */
    public function addToContract(\StructType\JPSOAP_HotelRatePlanContract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_HotelRatePlanContract) {
            throw new \InvalidArgumentException(sprintf('The Contract property can only contain items of \StructType\JPSOAP_HotelRatePlanContract, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Contract[] = $item;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JP_HotelRatesRS
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCodeEncrypt value
     * @return string|null
     */
    public function getHotelCodeEncrypt()
    {
        return $this->HotelCodeEncrypt;
    }
    /**
     * Set HotelCodeEncrypt value
     * @param string $hotelCodeEncrypt
     * @return \StructType\JP_HotelRatesRS
     */
    public function setHotelCodeEncrypt($hotelCodeEncrypt = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeEncrypt) && !is_string($hotelCodeEncrypt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCodeEncrypt)), __LINE__);
        }
        $this->HotelCodeEncrypt = $hotelCodeEncrypt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelRatesRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
