<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelContentRQ StructType
 * @subpackage Structs
 */
class JP_HotelContentRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The HotelContentList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelSimpleContent
     */
    public $HotelContentList;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Context
     * @var string
     */
    public $Context;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for JP_HotelContentRQ
     * @uses JP_HotelContentRQ::setLogin()
     * @uses JP_HotelContentRQ::setHotelContentList()
     * @uses JP_HotelContentRQ::setRestrictedOptions()
     * @uses JP_HotelContentRQ::setVersion()
     * @uses JP_HotelContentRQ::setContext()
     * @uses JP_HotelContentRQ::setLanguage()
     * @param \StructType\JP_Login $login
     * @param \ArrayType\ArrayOfJP_HotelSimpleContent $hotelContentList
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $context
     * @param string $language
     */
    public function __construct(\StructType\JP_Login $login = null, \ArrayType\ArrayOfJP_HotelSimpleContent $hotelContentList = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $context = null, $language = null)
    {
        $this
            ->setLogin($login)
            ->setHotelContentList($hotelContentList)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setContext($context)
            ->setLanguage($language);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_HotelContentRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get HotelContentList value
     * @return \ArrayType\ArrayOfJP_HotelSimpleContent|null
     */
    public function getHotelContentList()
    {
        return $this->HotelContentList;
    }
    /**
     * Set HotelContentList value
     * @param \ArrayType\ArrayOfJP_HotelSimpleContent $hotelContentList
     * @return \StructType\JP_HotelContentRQ
     */
    public function setHotelContentList(\ArrayType\ArrayOfJP_HotelSimpleContent $hotelContentList = null)
    {
        $this->HotelContentList = $hotelContentList;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_HotelContentRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_HotelContentRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Context value
     * @return string|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @param string $context
     * @return \StructType\JP_HotelContentRQ
     */
    public function setContext($context = null)
    {
        // validation for constraint: string
        if (!is_null($context) && !is_string($context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($context)), __LINE__);
        }
        $this->Context = $context;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_HotelContentRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelContentRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
