<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_CountryOfResidence StructType
 * @subpackage Structs
 */
class JPSOAP_CountryOfResidence extends AbstractStructBase
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Country[]
     */
    public $Country;
    /**
     * The Allowed
     * @var bool
     */
    public $Allowed;
    /**
     * Constructor method for JPSOAP_CountryOfResidence
     * @uses JPSOAP_CountryOfResidence::setCountry()
     * @uses JPSOAP_CountryOfResidence::setAllowed()
     * @param \StructType\JP_Country[] $country
     * @param bool $allowed
     */
    public function __construct(array $country = array(), $allowed = null)
    {
        $this
            ->setCountry($country)
            ->setAllowed($allowed);
    }
    /**
     * Get Country value
     * @return \StructType\JP_Country[]|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Country[] $country
     * @return \StructType\JPSOAP_CountryOfResidence
     */
    public function setCountry(array $country = array())
    {
        foreach ($country as $jPSOAP_CountryOfResidenceCountryItem) {
            // validation for constraint: itemType
            if (!$jPSOAP_CountryOfResidenceCountryItem instanceof \StructType\JP_Country) {
                throw new \InvalidArgumentException(sprintf('The Country property can only contain items of \StructType\JP_Country, "%s" given', is_object($jPSOAP_CountryOfResidenceCountryItem) ? get_class($jPSOAP_CountryOfResidenceCountryItem) : gettype($jPSOAP_CountryOfResidenceCountryItem)), __LINE__);
            }
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Add item to Country value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Country $item
     * @return \StructType\JPSOAP_CountryOfResidence
     */
    public function addToCountry(\StructType\JP_Country $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Country) {
            throw new \InvalidArgumentException(sprintf('The Country property can only contain items of \StructType\JP_Country, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Country[] = $item;
        return $this;
    }
    /**
     * Get Allowed value
     * @return bool|null
     */
    public function getAllowed()
    {
        return $this->Allowed;
    }
    /**
     * Set Allowed value
     * @param bool $allowed
     * @return \StructType\JPSOAP_CountryOfResidence
     */
    public function setAllowed($allowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowed) && !is_bool($allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowed)), __LINE__);
        }
        $this->Allowed = $allowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_CountryOfResidence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
