<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PackageDailyProductType ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PackageDailyProductType extends AbstractStructArrayBase
{
    /**
     * The ProductTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageDailyProductType[]
     */
    public $ProductTypes;
    /**
     * Constructor method for ArrayOfJP_PackageDailyProductType
     * @uses ArrayOfJP_PackageDailyProductType::setProductTypes()
     * @param \StructType\JP_PackageDailyProductType[] $productTypes
     */
    public function __construct(array $productTypes = array())
    {
        $this
            ->setProductTypes($productTypes);
    }
    /**
     * Get ProductTypes value
     * @return \StructType\JP_PackageDailyProductType[]|null
     */
    public function getProductTypes()
    {
        return $this->ProductTypes;
    }
    /**
     * Set ProductTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageDailyProductType[] $productTypes
     * @return \ArrayType\ArrayOfJP_PackageDailyProductType
     */
    public function setProductTypes(array $productTypes = array())
    {
        foreach ($productTypes as $arrayOfJP_PackageDailyProductTypeProductTypesItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PackageDailyProductTypeProductTypesItem instanceof \StructType\JP_PackageDailyProductType) {
                throw new \InvalidArgumentException(sprintf('The ProductTypes property can only contain items of \StructType\JP_PackageDailyProductType, "%s" given', is_object($arrayOfJP_PackageDailyProductTypeProductTypesItem) ? get_class($arrayOfJP_PackageDailyProductTypeProductTypesItem) : gettype($arrayOfJP_PackageDailyProductTypeProductTypesItem)), __LINE__);
            }
        }
        $this->ProductTypes = $productTypes;
        return $this;
    }
    /**
     * Add item to ProductTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageDailyProductType $item
     * @return \ArrayType\ArrayOfJP_PackageDailyProductType
     */
    public function addToProductTypes(\StructType\JP_PackageDailyProductType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageDailyProductType) {
            throw new \InvalidArgumentException(sprintf('The ProductTypes property can only contain items of \StructType\JP_PackageDailyProductType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductTypes[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PackageDailyProductType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PackageDailyProductType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PackageDailyProductType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PackageDailyProductType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PackageDailyProductType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductTypes
     */
    public function getAttributeName()
    {
        return 'ProductTypes';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PackageDailyProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
