<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ItemBreakdown ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ItemBreakdown extends AbstractStructArrayBase
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ItemBreakdown[]
     */
    public $Item;
    /**
     * Constructor method for ArrayOfJP_ItemBreakdown
     * @uses ArrayOfJP_ItemBreakdown::setItem()
     * @param \StructType\JP_ItemBreakdown[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * @return \StructType\JP_ItemBreakdown[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ItemBreakdown[] $item
     * @return \ArrayType\ArrayOfJP_ItemBreakdown
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $arrayOfJP_ItemBreakdownItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ItemBreakdownItemItem instanceof \StructType\JP_ItemBreakdown) {
                throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \StructType\JP_ItemBreakdown, "%s" given', is_object($arrayOfJP_ItemBreakdownItemItem) ? get_class($arrayOfJP_ItemBreakdownItemItem) : gettype($arrayOfJP_ItemBreakdownItemItem)), __LINE__);
            }
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ItemBreakdown $item
     * @return \ArrayType\ArrayOfJP_ItemBreakdown
     */
    public function addToItem(\StructType\JP_ItemBreakdown $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ItemBreakdown) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \StructType\JP_ItemBreakdown, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ItemBreakdown|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ItemBreakdown|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ItemBreakdown|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ItemBreakdown|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ItemBreakdown|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Item
     */
    public function getAttributeName()
    {
        return 'Item';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ItemBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
