<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CruiseStation ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CruiseStation extends AbstractStructArrayBase
{
    /**
     * The Station
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CruiseStation[]
     */
    public $Station;
    /**
     * Constructor method for ArrayOfJP_CruiseStation
     * @uses ArrayOfJP_CruiseStation::setStation()
     * @param \StructType\JP_CruiseStation[] $station
     */
    public function __construct(array $station = array())
    {
        $this
            ->setStation($station);
    }
    /**
     * Get Station value
     * @return \StructType\JP_CruiseStation[]|null
     */
    public function getStation()
    {
        return $this->Station;
    }
    /**
     * Set Station value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseStation[] $station
     * @return \ArrayType\ArrayOfJP_CruiseStation
     */
    public function setStation(array $station = array())
    {
        foreach ($station as $arrayOfJP_CruiseStationStationItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CruiseStationStationItem instanceof \StructType\JP_CruiseStation) {
                throw new \InvalidArgumentException(sprintf('The Station property can only contain items of \StructType\JP_CruiseStation, "%s" given', is_object($arrayOfJP_CruiseStationStationItem) ? get_class($arrayOfJP_CruiseStationStationItem) : gettype($arrayOfJP_CruiseStationStationItem)), __LINE__);
            }
        }
        $this->Station = $station;
        return $this;
    }
    /**
     * Add item to Station value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseStation $item
     * @return \ArrayType\ArrayOfJP_CruiseStation
     */
    public function addToStation(\StructType\JP_CruiseStation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CruiseStation) {
            throw new \InvalidArgumentException(sprintf('The Station property can only contain items of \StructType\JP_CruiseStation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Station[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CruiseStation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CruiseStation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CruiseStation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CruiseStation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CruiseStation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Station
     */
    public function getAttributeName()
    {
        return 'Station';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_CruiseStation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
