<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJPSOAP_DateIntervals ArrayType
 * @subpackage Arrays
 */
class ArrayOfJPSOAP_DateIntervals extends AbstractStructArrayBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervals[]
     */
    public $Date;
    /**
     * Constructor method for ArrayOfJPSOAP_DateIntervals
     * @uses ArrayOfJPSOAP_DateIntervals::setDate()
     * @param \StructType\JPSOAP_DateIntervals[] $date
     */
    public function __construct(array $date = array())
    {
        $this
            ->setDate($date);
    }
    /**
     * Get Date value
     * @return \StructType\JPSOAP_DateIntervals[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_DateIntervals[] $date
     * @return \ArrayType\ArrayOfJPSOAP_DateIntervals
     */
    public function setDate(array $date = array())
    {
        foreach ($date as $arrayOfJPSOAP_DateIntervalsDateItem) {
            // validation for constraint: itemType
            if (!$arrayOfJPSOAP_DateIntervalsDateItem instanceof \StructType\JPSOAP_DateIntervals) {
                throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \StructType\JPSOAP_DateIntervals, "%s" given', is_object($arrayOfJPSOAP_DateIntervalsDateItem) ? get_class($arrayOfJPSOAP_DateIntervalsDateItem) : gettype($arrayOfJPSOAP_DateIntervalsDateItem)), __LINE__);
            }
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_DateIntervals $item
     * @return \ArrayType\ArrayOfJPSOAP_DateIntervals
     */
    public function addToDate(\StructType\JPSOAP_DateIntervals $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_DateIntervals) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \StructType\JPSOAP_DateIntervals, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Date
     */
    public function getAttributeName()
    {
        return 'Date';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJPSOAP_DateIntervals
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
