<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AgencyStaticData StructType
 * @subpackage Structs
 */
class JP_AgencyStaticData extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PhoneNumber
     */
    public $PhoneNumber;
    /**
     * The AgencyGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_AgencyGroup
     */
    public $AgencyGroup;
    /**
     * Constructor method for JP_AgencyStaticData
     * @uses JP_AgencyStaticData::setCode()
     * @uses JP_AgencyStaticData::setName()
     * @uses JP_AgencyStaticData::setEmail()
     * @uses JP_AgencyStaticData::setPhoneNumber()
     * @uses JP_AgencyStaticData::setAgencyGroup()
     * @param int $code
     * @param string $name
     * @param string $email
     * @param \StructType\JP_PhoneNumber $phoneNumber
     * @param \StructType\JP_AgencyGroup $agencyGroup
     */
    public function __construct($code = null, $name = null, $email = null, \StructType\JP_PhoneNumber $phoneNumber = null, \StructType\JP_AgencyGroup $agencyGroup = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setEmail($email)
            ->setPhoneNumber($phoneNumber)
            ->setAgencyGroup($agencyGroup);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_AgencyStaticData
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_AgencyStaticData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\JP_AgencyStaticData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return \StructType\JP_PhoneNumber|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param \StructType\JP_PhoneNumber $phoneNumber
     * @return \StructType\JP_AgencyStaticData
     */
    public function setPhoneNumber(\StructType\JP_PhoneNumber $phoneNumber = null)
    {
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get AgencyGroup value
     * @return \StructType\JP_AgencyGroup|null
     */
    public function getAgencyGroup()
    {
        return $this->AgencyGroup;
    }
    /**
     * Set AgencyGroup value
     * @param \StructType\JP_AgencyGroup $agencyGroup
     * @return \StructType\JP_AgencyStaticData
     */
    public function setAgencyGroup(\StructType\JP_AgencyGroup $agencyGroup = null)
    {
        $this->AgencyGroup = $agencyGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_AgencyStaticData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
