<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_CalculationBySeason EnumType
 * @subpackage Enumerations
 */
class JPSOAP_CalculationBySeason
{
    /**
     * Constant for value 'PerNight'
     * @return string 'PerNight'
     */
    const VALUE_PER_NIGHT = 'PerNight';
    /**
     * Constant for value 'PeriodWithMoreNightsApplyFirstNightPriceIfCoincidence'
     * @return string 'PeriodWithMoreNightsApplyFirstNightPriceIfCoincidence'
     */
    const VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_FIRST_NIGHT_PRICE_IF_COINCIDENCE = 'PeriodWithMoreNightsApplyFirstNightPriceIfCoincidence';
    /**
     * Constant for value 'PeriodWithMoreNightsApplyMostExpensivePriceIfCoincidence'
     * @return string 'PeriodWithMoreNightsApplyMostExpensivePriceIfCoincidence'
     */
    const VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_MOST_EXPENSIVE_PRICE_IF_COINCIDENCE = 'PeriodWithMoreNightsApplyMostExpensivePriceIfCoincidence';
    /**
     * Constant for value 'PeriodWithMoreNightsApplyCheapestPriceIfCoincidence'
     * @return string 'PeriodWithMoreNightsApplyCheapestPriceIfCoincidence'
     */
    const VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_CHEAPEST_PRICE_IF_COINCIDENCE = 'PeriodWithMoreNightsApplyCheapestPriceIfCoincidence';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PER_NIGHT
     * @uses self::VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_FIRST_NIGHT_PRICE_IF_COINCIDENCE
     * @uses self::VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_MOST_EXPENSIVE_PRICE_IF_COINCIDENCE
     * @uses self::VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_CHEAPEST_PRICE_IF_COINCIDENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PER_NIGHT,
            self::VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_FIRST_NIGHT_PRICE_IF_COINCIDENCE,
            self::VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_MOST_EXPENSIVE_PRICE_IF_COINCIDENCE,
            self::VALUE_PERIOD_WITH_MORE_NIGHTS_APPLY_CHEAPEST_PRICE_IF_COINCIDENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
