<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferOption StructType
 * @subpackage Structs
 */
class JP_TransferOption extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The OriginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginName;
    /**
     * The DestinationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationName;
    /**
     * The Dates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceDate
     */
    public $Dates;
    /**
     * The TransferBookingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferBookingInfo
     */
    public $TransferBookingInfo;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Origin
     * @var int
     */
    public $Origin;
    /**
     * The OriginType
     * @var string
     */
    public $OriginType;
    /**
     * The Destination
     * @var int
     */
    public $Destination;
    /**
     * The DestinationType
     * @var string
     */
    public $DestinationType;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The Route
     * @var string
     */
    public $Route;
    /**
     * Constructor method for JP_TransferOption
     * @uses JP_TransferOption::setName()
     * @uses JP_TransferOption::setDescription()
     * @uses JP_TransferOption::setImages()
     * @uses JP_TransferOption::setOriginName()
     * @uses JP_TransferOption::setDestinationName()
     * @uses JP_TransferOption::setDates()
     * @uses JP_TransferOption::setTransferBookingInfo()
     * @uses JP_TransferOption::setStart()
     * @uses JP_TransferOption::setEnd()
     * @uses JP_TransferOption::setOrigin()
     * @uses JP_TransferOption::setOriginType()
     * @uses JP_TransferOption::setDestination()
     * @uses JP_TransferOption::setDestinationType()
     * @uses JP_TransferOption::setDuration()
     * @uses JP_TransferOption::setRoute()
     * @param string $name
     * @param string $description
     * @param \ArrayType\ArrayOfString1 $images
     * @param string $originName
     * @param string $destinationName
     * @param \ArrayType\ArrayOfJP_ServiceDate $dates
     * @param \StructType\JP_TransferBookingInfo $transferBookingInfo
     * @param string $start
     * @param string $end
     * @param int $origin
     * @param string $originType
     * @param int $destination
     * @param string $destinationType
     * @param string $duration
     * @param string $route
     */
    public function __construct($name = null, $description = null, \ArrayType\ArrayOfString1 $images = null, $originName = null, $destinationName = null, \ArrayType\ArrayOfJP_ServiceDate $dates = null, \StructType\JP_TransferBookingInfo $transferBookingInfo = null, $start = null, $end = null, $origin = null, $originType = null, $destination = null, $destinationType = null, $duration = null, $route = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setImages($images)
            ->setOriginName($originName)
            ->setDestinationName($destinationName)
            ->setDates($dates)
            ->setTransferBookingInfo($transferBookingInfo)
            ->setStart($start)
            ->setEnd($end)
            ->setOrigin($origin)
            ->setOriginType($originType)
            ->setDestination($destination)
            ->setDestinationType($destinationType)
            ->setDuration($duration)
            ->setRoute($route);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_TransferOption
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_TransferOption
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_TransferOption
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get OriginName value
     * @return string|null
     */
    public function getOriginName()
    {
        return $this->OriginName;
    }
    /**
     * Set OriginName value
     * @param string $originName
     * @return \StructType\JP_TransferOption
     */
    public function setOriginName($originName = null)
    {
        // validation for constraint: string
        if (!is_null($originName) && !is_string($originName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originName)), __LINE__);
        }
        $this->OriginName = $originName;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return string|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param string $destinationName
     * @return \StructType\JP_TransferOption
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationName)), __LINE__);
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get Dates value
     * @return \ArrayType\ArrayOfJP_ServiceDate|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @param \ArrayType\ArrayOfJP_ServiceDate $dates
     * @return \StructType\JP_TransferOption
     */
    public function setDates(\ArrayType\ArrayOfJP_ServiceDate $dates = null)
    {
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Get TransferBookingInfo value
     * @return \StructType\JP_TransferBookingInfo|null
     */
    public function getTransferBookingInfo()
    {
        return $this->TransferBookingInfo;
    }
    /**
     * Set TransferBookingInfo value
     * @param \StructType\JP_TransferBookingInfo $transferBookingInfo
     * @return \StructType\JP_TransferOption
     */
    public function setTransferBookingInfo(\StructType\JP_TransferBookingInfo $transferBookingInfo = null)
    {
        $this->TransferBookingInfo = $transferBookingInfo;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_TransferOption
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_TransferOption
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Origin value
     * @return int|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param int $origin
     * @return \StructType\JP_TransferOption
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: int
        if (!is_null($origin) && !is_numeric($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get OriginType value
     * @return string|null
     */
    public function getOriginType()
    {
        return $this->OriginType;
    }
    /**
     * Set OriginType value
     * @param string $originType
     * @return \StructType\JP_TransferOption
     */
    public function setOriginType($originType = null)
    {
        // validation for constraint: string
        if (!is_null($originType) && !is_string($originType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originType)), __LINE__);
        }
        $this->OriginType = $originType;
        return $this;
    }
    /**
     * Get Destination value
     * @return int|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param int $destination
     * @return \StructType\JP_TransferOption
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: int
        if (!is_null($destination) && !is_numeric($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get DestinationType value
     * @return string|null
     */
    public function getDestinationType()
    {
        return $this->DestinationType;
    }
    /**
     * Set DestinationType value
     * @param string $destinationType
     * @return \StructType\JP_TransferOption
     */
    public function setDestinationType($destinationType = null)
    {
        // validation for constraint: string
        if (!is_null($destinationType) && !is_string($destinationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationType)), __LINE__);
        }
        $this->DestinationType = $destinationType;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\JP_TransferOption
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @uses \EnumType\JP_RouteType::valueIsValid()
     * @uses \EnumType\JP_RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $route
     * @return \StructType\JP_TransferOption
     */
    public function setRoute($route = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RouteType::valueIsValid($route)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $route, implode(', ', \EnumType\JP_RouteType::getValidValues())), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
