<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageItinerary StructType
 * @subpackage Structs
 */
class JP_PackageItinerary extends AbstractStructBase
{
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Subtitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subtitle;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DailyProductTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageDailyProductType
     */
    public $DailyProductTypes;
    /**
     * The Day
     * @var string
     */
    public $Day;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * Constructor method for JP_PackageItinerary
     * @uses JP_PackageItinerary::setTitle()
     * @uses JP_PackageItinerary::setSubtitle()
     * @uses JP_PackageItinerary::setDescription()
     * @uses JP_PackageItinerary::setDailyProductTypes()
     * @uses JP_PackageItinerary::setDay()
     * @uses JP_PackageItinerary::setDuration()
     * @param string $title
     * @param string $subtitle
     * @param string $description
     * @param \ArrayType\ArrayOfJP_PackageDailyProductType $dailyProductTypes
     * @param string $day
     * @param string $duration
     */
    public function __construct($title = null, $subtitle = null, $description = null, \ArrayType\ArrayOfJP_PackageDailyProductType $dailyProductTypes = null, $day = null, $duration = null)
    {
        $this
            ->setTitle($title)
            ->setSubtitle($subtitle)
            ->setDescription($description)
            ->setDailyProductTypes($dailyProductTypes)
            ->setDay($day)
            ->setDuration($duration);
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\JP_PackageItinerary
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Subtitle value
     * @return string|null
     */
    public function getSubtitle()
    {
        return $this->Subtitle;
    }
    /**
     * Set Subtitle value
     * @param string $subtitle
     * @return \StructType\JP_PackageItinerary
     */
    public function setSubtitle($subtitle = null)
    {
        // validation for constraint: string
        if (!is_null($subtitle) && !is_string($subtitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subtitle)), __LINE__);
        }
        $this->Subtitle = $subtitle;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_PackageItinerary
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DailyProductTypes value
     * @return \ArrayType\ArrayOfJP_PackageDailyProductType|null
     */
    public function getDailyProductTypes()
    {
        return $this->DailyProductTypes;
    }
    /**
     * Set DailyProductTypes value
     * @param \ArrayType\ArrayOfJP_PackageDailyProductType $dailyProductTypes
     * @return \StructType\JP_PackageItinerary
     */
    public function setDailyProductTypes(\ArrayType\ArrayOfJP_PackageDailyProductType $dailyProductTypes = null)
    {
        $this->DailyProductTypes = $dailyProductTypes;
        return $this;
    }
    /**
     * Get Day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param string $day
     * @return \StructType\JP_PackageItinerary
     */
    public function setDay($day = null)
    {
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\JP_PackageItinerary
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
