<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CityComplex ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CityComplex extends AbstractStructArrayBase
{
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CityComplex[]
     */
    public $City;
    /**
     * Constructor method for ArrayOfJP_CityComplex
     * @uses ArrayOfJP_CityComplex::setCity()
     * @param \StructType\JP_CityComplex[] $city
     */
    public function __construct(array $city = array())
    {
        $this
            ->setCity($city);
    }
    /**
     * Get City value
     * @return \StructType\JP_CityComplex[]|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CityComplex[] $city
     * @return \ArrayType\ArrayOfJP_CityComplex
     */
    public function setCity(array $city = array())
    {
        foreach ($city as $arrayOfJP_CityComplexCityItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CityComplexCityItem instanceof \StructType\JP_CityComplex) {
                throw new \InvalidArgumentException(sprintf('The City property can only contain items of \StructType\JP_CityComplex, "%s" given', is_object($arrayOfJP_CityComplexCityItem) ? get_class($arrayOfJP_CityComplexCityItem) : gettype($arrayOfJP_CityComplexCityItem)), __LINE__);
            }
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Add item to City value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CityComplex $item
     * @return \ArrayType\ArrayOfJP_CityComplex
     */
    public function addToCity(\StructType\JP_CityComplex $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CityComplex) {
            throw new \InvalidArgumentException(sprintf('The City property can only contain items of \StructType\JP_CityComplex, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->City[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CityComplex|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CityComplex|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CityComplex|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CityComplex|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CityComplex|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string City
     */
    public function getAttributeName()
    {
        return 'City';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_CityComplex
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
