<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString8 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString8 extends AbstractStructArrayBase
{
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PromoCode;
    /**
     * Constructor method for ArrayOfString8
     * @uses ArrayOfString8::setPromoCode()
     * @param string[] $promoCode
     */
    public function __construct(array $promoCode = array())
    {
        $this
            ->setPromoCode($promoCode);
    }
    /**
     * Get PromoCode value
     * @return string[]|null
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromoCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromoCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromoCodeForArrayConstraintsFromSetPromoCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString8PromoCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString8PromoCodeItem)) {
                $invalidValues[] = is_object($arrayOfString8PromoCodeItem) ? get_class($arrayOfString8PromoCodeItem) : sprintf('%s(%s)', gettype($arrayOfString8PromoCodeItem), var_export($arrayOfString8PromoCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromoCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromoCode value
     * @throws \InvalidArgumentException
     * @param string[] $promoCode
     * @return \ArrayType\ArrayOfString8
     */
    public function setPromoCode(array $promoCode = array())
    {
        // validation for constraint: array
        if ('' !== ($promoCodeArrayErrorMessage = self::validatePromoCodeForArrayConstraintsFromSetPromoCode($promoCode))) {
            throw new \InvalidArgumentException($promoCodeArrayErrorMessage, __LINE__);
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Add item to PromoCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString8
     */
    public function addToPromoCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PromoCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PromoCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PromoCode
     */
    public function getAttributeName()
    {
        return 'PromoCode';
    }
}
