<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Board ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Board extends AbstractStructArrayBase
{
    /**
     * The Board
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Board[]
     */
    public $Board;
    /**
     * Constructor method for ArrayOfJP_Board
     * @uses ArrayOfJP_Board::setBoard()
     * @param \StructType\JP_Board[] $board
     */
    public function __construct(array $board = array())
    {
        $this
            ->setBoard($board);
    }
    /**
     * Get Board value
     * @return \StructType\JP_Board[]|null
     */
    public function getBoard()
    {
        return $this->Board;
    }
    /**
     * This method is responsible for validating the values passed to the setBoard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBoard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBoardForArrayConstraintsFromSetBoard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_BoardBoardItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_BoardBoardItem instanceof \StructType\JP_Board) {
                $invalidValues[] = is_object($arrayOfJP_BoardBoardItem) ? get_class($arrayOfJP_BoardBoardItem) : sprintf('%s(%s)', gettype($arrayOfJP_BoardBoardItem), var_export($arrayOfJP_BoardBoardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Board property can only contain items of type \StructType\JP_Board, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Board value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Board[] $board
     * @return \ArrayType\ArrayOfJP_Board
     */
    public function setBoard(array $board = array())
    {
        // validation for constraint: array
        if ('' !== ($boardArrayErrorMessage = self::validateBoardForArrayConstraintsFromSetBoard($board))) {
            throw new \InvalidArgumentException($boardArrayErrorMessage, __LINE__);
        }
        $this->Board = $board;
        return $this;
    }
    /**
     * Add item to Board value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Board $item
     * @return \ArrayType\ArrayOfJP_Board
     */
    public function addToBoard(\StructType\JP_Board $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Board) {
            throw new \InvalidArgumentException(sprintf('The Board property can only contain items of type \StructType\JP_Board, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Board[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Board|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Board|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Board|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Board|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Board|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Board
     */
    public function getAttributeName()
    {
        return 'Board';
    }
}
