<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelInventorySimpleInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelInventorySimpleInfo extends AbstractStructArrayBase
{
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelInventorySimpleInfo[]
     */
    public $Hotel;
    /**
     * Constructor method for ArrayOfJP_HotelInventorySimpleInfo
     * @uses ArrayOfJP_HotelInventorySimpleInfo::setHotel()
     * @param \StructType\JP_HotelInventorySimpleInfo[] $hotel
     */
    public function __construct(array $hotel = array())
    {
        $this
            ->setHotel($hotel);
    }
    /**
     * Get Hotel value
     * @return \StructType\JP_HotelInventorySimpleInfo[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelForArrayConstraintsFromSetHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_HotelInventorySimpleInfoHotelItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelInventorySimpleInfoHotelItem instanceof \StructType\JP_HotelInventorySimpleInfo) {
                $invalidValues[] = is_object($arrayOfJP_HotelInventorySimpleInfoHotelItem) ? get_class($arrayOfJP_HotelInventorySimpleInfoHotelItem) : sprintf('%s(%s)', gettype($arrayOfJP_HotelInventorySimpleInfoHotelItem), var_export($arrayOfJP_HotelInventorySimpleInfoHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel property can only contain items of type \StructType\JP_HotelInventorySimpleInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelInventorySimpleInfo[] $hotel
     * @return \ArrayType\ArrayOfJP_HotelInventorySimpleInfo
     */
    public function setHotel(array $hotel = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelArrayErrorMessage = self::validateHotelForArrayConstraintsFromSetHotel($hotel))) {
            throw new \InvalidArgumentException($hotelArrayErrorMessage, __LINE__);
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelInventorySimpleInfo $item
     * @return \ArrayType\ArrayOfJP_HotelInventorySimpleInfo
     */
    public function addToHotel(\StructType\JP_HotelInventorySimpleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelInventorySimpleInfo) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of type \StructType\JP_HotelInventorySimpleInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelInventorySimpleInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelInventorySimpleInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelInventorySimpleInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelInventorySimpleInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelInventorySimpleInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Hotel
     */
    public function getAttributeName()
    {
        return 'Hotel';
    }
}
