<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Destination ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Destination extends AbstractStructArrayBase
{
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Destination[]
     */
    public $Destination;
    /**
     * Constructor method for ArrayOfJP_Destination
     * @uses ArrayOfJP_Destination::setDestination()
     * @param \StructType\JP_Destination[] $destination
     */
    public function __construct(array $destination = array())
    {
        $this
            ->setDestination($destination);
    }
    /**
     * Get Destination value
     * @return \StructType\JP_Destination[]|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * This method is responsible for validating the values passed to the setDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDestination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDestinationForArrayConstraintsFromSetDestination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_DestinationDestinationItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_DestinationDestinationItem instanceof \StructType\JP_Destination) {
                $invalidValues[] = is_object($arrayOfJP_DestinationDestinationItem) ? get_class($arrayOfJP_DestinationDestinationItem) : sprintf('%s(%s)', gettype($arrayOfJP_DestinationDestinationItem), var_export($arrayOfJP_DestinationDestinationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Destination property can only contain items of type \StructType\JP_Destination, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Destination value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Destination[] $destination
     * @return \ArrayType\ArrayOfJP_Destination
     */
    public function setDestination(array $destination = array())
    {
        // validation for constraint: array
        if ('' !== ($destinationArrayErrorMessage = self::validateDestinationForArrayConstraintsFromSetDestination($destination))) {
            throw new \InvalidArgumentException($destinationArrayErrorMessage, __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Add item to Destination value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Destination $item
     * @return \ArrayType\ArrayOfJP_Destination
     */
    public function addToDestination(\StructType\JP_Destination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Destination) {
            throw new \InvalidArgumentException(sprintf('The Destination property can only contain items of type \StructType\JP_Destination, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Destination[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Destination|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Destination|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Destination|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Destination|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Destination|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Destination
     */
    public function getAttributeName()
    {
        return 'Destination';
    }
}
