<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SeatGroup StructType
 * @subpackage Structs
 */
class JP_SeatGroup extends AbstractStructBase
{
    /**
     * The Group
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Group;
    /**
     * The GroupFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_GroupFee
     */
    public $GroupFee;
    /**
     * The GroupDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_GroupDetail
     */
    public $GroupDetail;
    /**
     * Constructor method for JP_SeatGroup
     * @uses JP_SeatGroup::setGroup()
     * @uses JP_SeatGroup::setGroupFee()
     * @uses JP_SeatGroup::setGroupDetail()
     * @param int $group
     * @param \StructType\JP_GroupFee $groupFee
     * @param \StructType\JP_GroupDetail $groupDetail
     */
    public function __construct($group = null, \StructType\JP_GroupFee $groupFee = null, \StructType\JP_GroupDetail $groupDetail = null)
    {
        $this
            ->setGroup($group)
            ->setGroupFee($groupFee)
            ->setGroupDetail($groupDetail);
    }
    /**
     * Get Group value
     * @return int
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param int $group
     * @return \StructType\JP_SeatGroup
     */
    public function setGroup($group = null)
    {
        // validation for constraint: int
        if (!is_null($group) && !(is_int($group) || ctype_digit($group))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($group, true), gettype($group)), __LINE__);
        }
        $this->Group = $group;
        return $this;
    }
    /**
     * Get GroupFee value
     * @return \StructType\JP_GroupFee|null
     */
    public function getGroupFee()
    {
        return $this->GroupFee;
    }
    /**
     * Set GroupFee value
     * @param \StructType\JP_GroupFee $groupFee
     * @return \StructType\JP_SeatGroup
     */
    public function setGroupFee(\StructType\JP_GroupFee $groupFee = null)
    {
        $this->GroupFee = $groupFee;
        return $this;
    }
    /**
     * Get GroupDetail value
     * @return \StructType\JP_GroupDetail|null
     */
    public function getGroupDetail()
    {
        return $this->GroupDetail;
    }
    /**
     * Set GroupDetail value
     * @param \StructType\JP_GroupDetail $groupDetail
     * @return \StructType\JP_SeatGroup
     */
    public function setGroupDetail(\StructType\JP_GroupDetail $groupDetail = null)
    {
        $this->GroupDetail = $groupDetail;
        return $this;
    }
}
