<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CustomerRead
     * Meta information extracted from the WSDL
     * - documentation: Generic Customer Read
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerRead $parameters
     * @return \StructType\CustomerReadResponse|bool
     */
    public function CustomerRead(\StructType\CustomerRead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CustomerReadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
