<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Description ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Description extends AbstractStructArrayBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Description[]
     */
    public $Description;
    /**
     * Constructor method for ArrayOfJP_Description
     * @uses ArrayOfJP_Description::setDescription()
     * @param \StructType\JP_Description[] $description
     */
    public function __construct(array $description = array())
    {
        $this
            ->setDescription($description);
    }
    /**
     * Get Description value
     * @return \StructType\JP_Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_DescriptionDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_DescriptionDescriptionItem instanceof \StructType\JP_Description) {
                $invalidValues[] = is_object($arrayOfJP_DescriptionDescriptionItem) ? get_class($arrayOfJP_DescriptionDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfJP_DescriptionDescriptionItem), var_export($arrayOfJP_DescriptionDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\JP_Description, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Description[] $description
     * @return \ArrayType\ArrayOfJP_Description
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Description $item
     * @return \ArrayType\ArrayOfJP_Description
     */
    public function addToDescription(\StructType\JP_Description $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Description) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\JP_Description, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Description|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Description|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Description|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Description|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Description|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Description
     */
    public function getAttributeName()
    {
        return 'Description';
    }
}
