<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentHotelsModify StructType
 * @subpackage Structs
 */
class JP_SearchSegmentHotelsModify extends AbstractStructBase
{
    /**
     * The HotelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelCode;
    /**
     * The Board
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Board
     */
    public $Board;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for JP_SearchSegmentHotelsModify
     * @uses JP_SearchSegmentHotelsModify::setHotelCode()
     * @uses JP_SearchSegmentHotelsModify::setBoard()
     * @uses JP_SearchSegmentHotelsModify::setStart()
     * @uses JP_SearchSegmentHotelsModify::setEnd()
     * @param string $hotelCode
     * @param \StructType\JP_Board $board
     * @param string $start
     * @param string $end
     */
    public function __construct($hotelCode = null, \StructType\JP_Board $board = null, $start = null, $end = null)
    {
        $this
            ->setHotelCode($hotelCode)
            ->setBoard($board)
            ->setStart($start)
            ->setEnd($end);
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JP_SearchSegmentHotelsModify
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get Board value
     * @return \StructType\JP_Board|null
     */
    public function getBoard()
    {
        return $this->Board;
    }
    /**
     * Set Board value
     * @param \StructType\JP_Board $board
     * @return \StructType\JP_SearchSegmentHotelsModify
     */
    public function setBoard(\StructType\JP_Board $board = null)
    {
        $this->Board = $board;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_SearchSegmentHotelsModify
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_SearchSegmentHotelsModify
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SearchSegmentHotelsModify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
