<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseSegment StructType
 * @subpackage Structs
 */
class JP_CruiseSegment extends AbstractStructBase
{
    /**
     * The DepartureAirportName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartureAirportName;
    /**
     * The ArrivalAirportName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalAirportName;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The DepartureAirport
     * @var string
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * @var string
     */
    public $ArrivalAirport;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The OperatingAirline
     * @var string
     */
    public $OperatingAirline;
    /**
     * The MarquetingAirline
     * @var string
     */
    public $MarquetingAirline;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * Constructor method for JP_CruiseSegment
     * @uses JP_CruiseSegment::setDepartureAirportName()
     * @uses JP_CruiseSegment::setArrivalAirportName()
     * @uses JP_CruiseSegment::setOrder()
     * @uses JP_CruiseSegment::setDepartureAirport()
     * @uses JP_CruiseSegment::setArrivalAirport()
     * @uses JP_CruiseSegment::setDepartureDate()
     * @uses JP_CruiseSegment::setArrivalDate()
     * @uses JP_CruiseSegment::setOperatingAirline()
     * @uses JP_CruiseSegment::setMarquetingAirline()
     * @uses JP_CruiseSegment::setFlightNumber()
     * @param string $departureAirportName
     * @param string $arrivalAirportName
     * @param int $order
     * @param string $departureAirport
     * @param string $arrivalAirport
     * @param string $departureDate
     * @param string $arrivalDate
     * @param string $operatingAirline
     * @param string $marquetingAirline
     * @param string $flightNumber
     */
    public function __construct($departureAirportName = null, $arrivalAirportName = null, $order = null, $departureAirport = null, $arrivalAirport = null, $departureDate = null, $arrivalDate = null, $operatingAirline = null, $marquetingAirline = null, $flightNumber = null)
    {
        $this
            ->setDepartureAirportName($departureAirportName)
            ->setArrivalAirportName($arrivalAirportName)
            ->setOrder($order)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setOperatingAirline($operatingAirline)
            ->setMarquetingAirline($marquetingAirline)
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get DepartureAirportName value
     * @return string|null
     */
    public function getDepartureAirportName()
    {
        return $this->DepartureAirportName;
    }
    /**
     * Set DepartureAirportName value
     * @param string $departureAirportName
     * @return \StructType\JP_CruiseSegment
     */
    public function setDepartureAirportName($departureAirportName = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportName) && !is_string($departureAirportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureAirportName)), __LINE__);
        }
        $this->DepartureAirportName = $departureAirportName;
        return $this;
    }
    /**
     * Get ArrivalAirportName value
     * @return string|null
     */
    public function getArrivalAirportName()
    {
        return $this->ArrivalAirportName;
    }
    /**
     * Set ArrivalAirportName value
     * @param string $arrivalAirportName
     * @return \StructType\JP_CruiseSegment
     */
    public function setArrivalAirportName($arrivalAirportName = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportName) && !is_string($arrivalAirportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalAirportName)), __LINE__);
        }
        $this->ArrivalAirportName = $arrivalAirportName;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_CruiseSegment
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return string|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param string $departureAirport
     * @return \StructType\JP_CruiseSegment
     */
    public function setDepartureAirport($departureAirport = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirport) && !is_string($departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureAirport)), __LINE__);
        }
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return string|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param string $arrivalAirport
     * @return \StructType\JP_CruiseSegment
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirport) && !is_string($arrivalAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalAirport)), __LINE__);
        }
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\JP_CruiseSegment
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\JP_CruiseSegment
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return string|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param string $operatingAirline
     * @return \StructType\JP_CruiseSegment
     */
    public function setOperatingAirline($operatingAirline = null)
    {
        // validation for constraint: string
        if (!is_null($operatingAirline) && !is_string($operatingAirline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatingAirline)), __LINE__);
        }
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get MarquetingAirline value
     * @return string|null
     */
    public function getMarquetingAirline()
    {
        return $this->MarquetingAirline;
    }
    /**
     * Set MarquetingAirline value
     * @param string $marquetingAirline
     * @return \StructType\JP_CruiseSegment
     */
    public function setMarquetingAirline($marquetingAirline = null)
    {
        // validation for constraint: string
        if (!is_null($marquetingAirline) && !is_string($marquetingAirline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marquetingAirline)), __LINE__);
        }
        $this->MarquetingAirline = $marquetingAirline;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\JP_CruiseSegment
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
