<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarCheckAvailOption StructType
 * @subpackage Structs
 */
class JP_RentacarCheckAvailOption extends AbstractStructBase
{
    /**
     * The RentacarInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarInfo
     */
    public $RentacarInfo;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The SaleContractName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SaleContractName;
    /**
     * The CostContractName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostContractName;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The PickUpCode
     * @var string
     */
    public $PickUpCode;
    /**
     * The DropOffCode
     * @var string
     */
    public $DropOffCode;
    /**
     * The AcrissCode
     * @var string
     */
    public $AcrissCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_RentacarCheckAvailOption
     * @uses JP_RentacarCheckAvailOption::setRentacarInfo()
     * @uses JP_RentacarCheckAvailOption::setPrices()
     * @uses JP_RentacarCheckAvailOption::setSaleContractName()
     * @uses JP_RentacarCheckAvailOption::setCostContractName()
     * @uses JP_RentacarCheckAvailOption::setAdditionalElements()
     * @uses JP_RentacarCheckAvailOption::setPickUpCode()
     * @uses JP_RentacarCheckAvailOption::setDropOffCode()
     * @uses JP_RentacarCheckAvailOption::setAcrissCode()
     * @uses JP_RentacarCheckAvailOption::setRatePlanCode()
     * @uses JP_RentacarCheckAvailOption::setStatus()
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $saleContractName
     * @param string $costContractName
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @param string $pickUpCode
     * @param string $dropOffCode
     * @param string $acrissCode
     * @param string $ratePlanCode
     * @param string $status
     */
    public function __construct(\StructType\JP_RentacarInfo $rentacarInfo = null, \ArrayType\ArrayOfJP_Price $prices = null, $saleContractName = null, $costContractName = null, \StructType\JP_RentacarAdditionalElements $additionalElements = null, $pickUpCode = null, $dropOffCode = null, $acrissCode = null, $ratePlanCode = null, $status = null)
    {
        $this
            ->setRentacarInfo($rentacarInfo)
            ->setPrices($prices)
            ->setSaleContractName($saleContractName)
            ->setCostContractName($costContractName)
            ->setAdditionalElements($additionalElements)
            ->setPickUpCode($pickUpCode)
            ->setDropOffCode($dropOffCode)
            ->setAcrissCode($acrissCode)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status);
    }
    /**
     * Get RentacarInfo value
     * @return \StructType\JP_RentacarInfo|null
     */
    public function getRentacarInfo()
    {
        return $this->RentacarInfo;
    }
    /**
     * Set RentacarInfo value
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setRentacarInfo(\StructType\JP_RentacarInfo $rentacarInfo = null)
    {
        $this->RentacarInfo = $rentacarInfo;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get SaleContractName value
     * @return string|null
     */
    public function getSaleContractName()
    {
        return $this->SaleContractName;
    }
    /**
     * Set SaleContractName value
     * @param string $saleContractName
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setSaleContractName($saleContractName = null)
    {
        // validation for constraint: string
        if (!is_null($saleContractName) && !is_string($saleContractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleContractName)), __LINE__);
        }
        $this->SaleContractName = $saleContractName;
        return $this;
    }
    /**
     * Get CostContractName value
     * @return string|null
     */
    public function getCostContractName()
    {
        return $this->CostContractName;
    }
    /**
     * Set CostContractName value
     * @param string $costContractName
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setCostContractName($costContractName = null)
    {
        // validation for constraint: string
        if (!is_null($costContractName) && !is_string($costContractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costContractName)), __LINE__);
        }
        $this->CostContractName = $costContractName;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_RentacarAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setAdditionalElements(\StructType\JP_RentacarAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get PickUpCode value
     * @return string|null
     */
    public function getPickUpCode()
    {
        return $this->PickUpCode;
    }
    /**
     * Set PickUpCode value
     * @param string $pickUpCode
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setPickUpCode($pickUpCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpCode) && !is_string($pickUpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickUpCode)), __LINE__);
        }
        $this->PickUpCode = $pickUpCode;
        return $this;
    }
    /**
     * Get DropOffCode value
     * @return string|null
     */
    public function getDropOffCode()
    {
        return $this->DropOffCode;
    }
    /**
     * Set DropOffCode value
     * @param string $dropOffCode
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setDropOffCode($dropOffCode = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffCode) && !is_string($dropOffCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dropOffCode)), __LINE__);
        }
        $this->DropOffCode = $dropOffCode;
        return $this;
    }
    /**
     * Get AcrissCode value
     * @return string|null
     */
    public function getAcrissCode()
    {
        return $this->AcrissCode;
    }
    /**
     * Set AcrissCode value
     * @param string $acrissCode
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setAcrissCode($acrissCode = null)
    {
        // validation for constraint: string
        if (!is_null($acrissCode) && !is_string($acrissCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acrissCode)), __LINE__);
        }
        $this->AcrissCode = $acrissCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RentacarCheckAvailOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
