<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FlightBookingInfo StructType
 * @subpackage Structs
 */
class JP_FlightBookingInfo extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingPrice
     */
    public $Price;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_FlightBookingInfo
     * @uses JP_FlightBookingInfo::setPrice()
     * @uses JP_FlightBookingInfo::setStatus()
     * @param \StructType\JP_BookingPrice $price
     * @param string $status
     */
    public function __construct(\StructType\JP_BookingPrice $price = null, $status = null)
    {
        $this
            ->setPrice($price)
            ->setStatus($status);
    }
    /**
     * Get Price value
     * @return \StructType\JP_BookingPrice|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_BookingPrice $price
     * @return \StructType\JP_FlightBookingInfo
     */
    public function setPrice(\StructType\JP_BookingPrice $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_FlightBookingInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FlightBookingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
