<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generic ServiceType
 * @subpackage Services
 */
class Generic extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GenericDataCatalogue
     * Meta informations extracted from the WSDL
     * - documentation: Generic Data Catalogue Request
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenericDataCatalogue $parameters
     * @return \StructType\GenericDataCatalogueResponse|bool
     */
    public function GenericDataCatalogue(\StructType\GenericDataCatalogue $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GenericDataCatalogue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GenericDataCatalogueResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
